/* Filename: ILexicalMarker.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Dec 8, 2007
 */
package edu.mit.discourse.core.rep.relation;


/** One line description goes here...
 * More detail goes here...
 *
 * @author M.A. Finlayson
 * @since 1.5.0
 */
public interface ILexicalMarker extends IArgument {
	
	public static final String nullDisplay = "(null)";
	public static final String implicitDisplay = " (implicit)";
	public static final String prefixImplicit = "implicit:";

	public Type getType();
	public String getImplicitMarker();
	public boolean isNull();
	public boolean isImplicit();
	public boolean isExplicit();
	
	public enum Type {
		NULL(),
		IMPLICIT(),
		EXPLICIT();
	}

}
