/* Filename: IIndicationStructure.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 18/09/2009
 */
package nil.ucm.indications2.core.rep;

import java.util.List;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.position.IHasPosition;

/** 
 *   A reference to a referent. This interface is different from the IReference interface in
 * edu.mit.discourse. This references are enriched with information about type, modifiers and nucleus.
 * Each IEnrichedReference will be associated with an IReference, and therefore to a IReferent
 *
 * @author Raquel Hervas
 * @version 1.0, (Sep. 18, 2009)
 * @since nil.ucm.reference.core 1.0.0
 */
public interface IIndicationStructure extends IHasPosition, IStructuredData {
	
	/**
	 *   Returns the name of this referent, used for easy identification. This name
	 * may correspond to the text corresponding to the reference. 
	 * 
	 * @return the name of this referent
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public String getName();
	
	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public boolean isCopularPredicate();
	
	/**
	 *   Returns the list of nuclei of this reference. As some references can be plural, there can
	 * be more than one nucleus. Each nucleus will be composed by a set of segments.
	 * All indications will have at least a nucleus.
	 *
	 * @return A set with the INucleus elements that correspond to the nuclei in the indication.
	 * @since nil.ucm.reference.core 1.0.0
	 */
	public List<? extends INucleus> getNuclei();
	
	/**
	 *   Returns the list of modifiers (probably they will be always adjectives) that are modifying
	 * the nucleus of the reference. If this is a plural reference, those modifiers are the ones applied 
	 * to the complete reference, not to singular inner references.
	 *
	 * @return A list with the strings that correspond to the modifiers of the nuclei of the reference.
	 * @since nil.ucm.reference.core 1.0.0
	 */
	public List<? extends IModifier> getModifiers();
	
	/**
	 *   Returns the reference that is being enriched by this EnrichedReference. From the Reference, it will
	 * be possible to access the Referent is necessary.
	 *
	 * @return The reference being enriched by this EnrichedReference.
	 * @since nil.ucm.reference.core 1.0.0
	 */
	public IReference getReference();
	
	/**
	 *   Returns the description of the referent of this reference.
	 *
	 * @return The description of the referent corresponding to this reference.
	 * @since nil.ucm.reference.core 1.0.0
	 */
	public IDesc getReferentDescription();
	
}
