/* Filename: DiscourseRelationRep.java
 * Author: Mark A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Oct 16, 2007
 */
package nil.ucm.indications2.core.rep.indication;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import nil.ucm.indications2.core.rep.indication.Indication.ConstituentBuilder;
import nil.ucm.indications2.core.rep.indication.Indication.IConstituentBuilder;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;


/** 
 * Referential expressions 
 *
 * @author Mark A. Finlayson
 * @version 1.00, (Oct 16, 2007)
 * @since 1.5.0
 */
public class IndicationRep extends AbstractRep {
	
	public static final String ID = "es.ucm.nil.indication.rep.indication";
	
	private static final long serialVersionUID = 1L;
	
	private static IRep instance = null;
	
	/**
	 * TODO: Write comment
	 *
	 * @return
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public static IRep getInstance(){
		if(instance == null) 
			instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
		return instance;
	}

	/**
	 * TODO: Write comment
	 *
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IndicationRep() {
		super(IIndication.class, 1);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.AbstractRep#initAntecedentsInternal(edu.mit.story.core.rep.IRepSet)
	 */
	@Override
	protected void initAntecedentsInternal(IRepSet container) {
		container.add(RefExpRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#serialize(java.lang.Object)
	 */
	public String serialize(IData data) {
		IIndication ind = (IIndication)data;
		List<String> fields = new LinkedList<String>();
		fields.add(Long.toString(ind.getReferringExpression().getID()));
		for(IConstituent c : ind.getConstituents())
			fields.add(serialize(c));
		return BlockMapper.PIPE.serialize(fields);
	}
	
	/**
	 * TODO: Write comment
	 *
	 * @param c
	 * @return
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public String serialize(IConstituent c){
		
		List<String> fields = new ArrayList<String>(3);
		if(c instanceof INucleus){
			fields.add("NUC");
		} else {
			fields.add("MOD");
		}
		
		fields.add(c.getType().name());
		fields.add(SegmentMapper.serializeStatic(c.getSegments()));
		
		return BlockMapper.COLON.serialize(fields);
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.rep.IRep#reconstitute(edu.mit.story.core.position.IHasPosition, java.lang.String, edu.mit.story.core.model.IStoryModel)
	 */
	public Indication reconstitute(IHasPosition p, String data, IStoryModel model) {
		List<String> fields = BlockMapper.PIPE.reconstitute(data);
		if(fields.size() < 2)
			throw new IllegalArgumentException();
		
		// refexp field
		long refID = Long.parseLong(fields.get(0));
		IDesc refDesc = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(refID);
		if(refDesc == null)
			return null;
		
		// constituents
		List<IConstituentBuilder> builders = new ArrayList<IConstituentBuilder>(fields.size()-1);
		IConstituentBuilder builder;
		for(int i = 1; i < fields.size(); i++){
			builder = reconstitute(fields.get(i), model);
			if(builder != null)
				builders.add(builder);
			
		}
		
		// make object
		return new Indication(refDesc, builders);
	}
	
	protected IConstituentBuilder reconstitute(String data, IStoryModel model){
		List<String> fields = BlockMapper.COLON.reconstitute(data);
		if(fields.size() != 3)
			throw new IllegalArgumentException();
		
		boolean isNucleus = fields.get(0).equals("NUC");
		IndicationType type = IndicationType.valueOf(fields.get(1));
		
		IValueMapper<ISegment> mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
		List<ISegment> segments = mapper.reconstitute(fields.get(2));
		
		return new ConstituentBuilder(isNucleus, type, new SegmentSet(segments));
	}
	
}
