/* Filename: UnknownIndicationTypeRules.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.HashSet;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IModifier;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.IndicationType;
import nil.ucm.indications2.core.rep.problems.UnknownTypeProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * Rule for the indication structures builder. It checks if there are indications with unknown type
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.core 1.0.0
 */
public class UnknownTypeRule extends AbstractBuildRule {

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications.core 1.0.0
	 */
	public UnknownTypeRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		Set<IDesc> ds = new HashSet<IDesc>();
		IIndicationStructure data;
		
		outer:for(IDesc d : model.getData().getDescriptions(IndicationStructureRep.getInstance())){
			data = (IIndicationStructure)d.getData();
			
			// check nuclei
			for(INucleus n : data.getNuclei()){
				if(n.getType() == IndicationType.UNKNOWN){
					ds.add(d);
					continue outer;
				}
			}
			
			// check modifiers
			for(IModifier m : data.getModifiers()){
				if(m.getType() == IndicationType.UNKNOWN){
					ds.add(d);
					continue outer;
				}
			}
		}
		if(ds.isEmpty()) return null;
		
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		if(isCompressing()){
			result.add(new UnknownTypeProblem(ds, getID()));
		} else {
			for(IDesc d : ds) result.add(new UnknownTypeProblem(d, getID()));
		}
		return result;
	}

}
