/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.MergeOutput;
import com.collabnet.subversion.merge.MergeResult;
import com.collabnet.subversion.merge.MergeResultsFolder;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.views.MergeResultsDecorator;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MergeAbortedWizardPage
extends WizardPage {
    private MergeOutput mergeOutput;
    private String errorMessage;
    private TreeViewer treeViewer;

    public MergeAbortedWizardPage(String pageName) {
        super(pageName, Messages.MergeAbortedWizardPage_title, Activator.getDefault().getImageDescriptor("svn_wizban.png"));
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(outerContainer, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(this.errorMessage);
        data = new GridData();
        data.widthHint = 500;
        label.setLayoutData((Object)data);
        new Label(composite, 0);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Messages.MergeAbortedWizardPage_conflicts);
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        data = new GridData(1808);
        conflictGroup.setLayoutData((Object)data);
        this.mergeOutput.setMergeResults(null);
        this.mergeOutput.setMergeResults(this.mergeOutput.getMergeResults());
        Tree tree = new Tree((Composite)conflictGroup, 768);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConflictsLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ConflictsContentProvider());
        this.treeViewer.setUseHashlookup(true);
        data = new GridData();
        data.heightHint = 200;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.setInput((Object)this.mergeOutput);
        this.treeViewer.expandAll();
        this.setMessage(Messages.MergeAbortedWizardPage_message);
        this.setControl((Control)outerContainer);
    }

    public void setMergeOutput(MergeOutput mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    class ConflictsContentProvider
    extends WorkbenchContentProvider {
        ConflictsContentProvider() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof MergeResultsFolder;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            MergeResultsFolder folder;
            if (parentElement instanceof MergeOutput) {
                MergeOutput mergeOutput = (MergeOutput)parentElement;
                MergeResult[] rootMergeResults = mergeOutput.getRootMergeResults(true);
                MergeResultsFolder[] mergeResultFolders = mergeOutput.getCompressedFolders(true);
                ArrayList<Object> returnObjects = new ArrayList<Object>();
                int i = 0;
                while (i < mergeResultFolders.length) {
                    returnObjects.add(mergeResultFolders[i]);
                    ++i;
                }
                i = 0;
                while (i < rootMergeResults.length) {
                    returnObjects.add(rootMergeResults[i]);
                    ++i;
                }
                Object[] returnArray = new Object[returnObjects.size()];
                returnObjects.toArray(returnArray);
                return returnArray;
            }
            if (parentElement instanceof MergeResultsFolder && (folder = (MergeResultsFolder)parentElement).isCompressed()) {
                return folder.getMergeResults(true);
            }
            return new Object[0];
        }
    }

    class ConflictsLabelProvider
    extends LabelProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        private CompareConfiguration compareConfiguration = new CompareConfiguration();
        private MergeResultsDecorator mergeResultsDecorator = new MergeResultsDecorator();

        ConflictsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof MergeResult) {
                MergeResult mergeResult = (MergeResult)element;
                return this.getImage(mergeResult);
            }
            if (element instanceof MergeResultsFolder) {
                MergeResultsFolder mergeResultsFolder = (MergeResultsFolder)element;
                Image image = mergeResultsFolder.getFolder().getFullPath().makeRelative().toString().length() > mergeResultsFolder.getRootFolderLength() ? this.workbenchLabelProvider.getImage((Object)mergeResultsFolder.getFolder()) : this.workbenchLabelProvider.getImage((Object)mergeResultsFolder.getMergeOutput().getResource());
                MergeResult mergeResult = mergeResultsFolder.getMergeResult();
                if (mergeResult != null) {
                    return this.getImage(mergeResult);
                }
                return this.compareConfiguration.getImage(image, 0);
            }
            return super.getImage(element);
        }

        private Image getImage(MergeResult mergeResult) {
            Image image = this.workbenchLabelProvider.getImage((Object)mergeResult.getResource());
            if (mergeResult.getAction() != null && mergeResult.getAction().trim().length() > 0) {
                image = this.mergeResultsDecorator.getImage(image, 4);
            }
            if (mergeResult.getPropertyAction() != null && mergeResult.getPropertyAction().trim().length() > 0) {
                image = this.mergeResultsDecorator.getImage(image, 12);
            }
            return image;
        }

        public String getText(Object element) {
            if (element instanceof MergeResultsFolder) {
                MergeResultsFolder folder = (MergeResultsFolder)element;
                return folder.toString();
            }
            if (element instanceof MergeResult) {
                MergeResult mergeResult = (MergeResult)element;
                return mergeResult.getResource().getName();
            }
            return super.getText(element);
        }
    }
}

