/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.helpers;

import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.ui.actions.ChangeTagDataFeatureActionGroup;
import edu.mit.parsing.ui.content.TagDataContentProvider;
import edu.mit.parsing.ui.label.TagDataLabelProvider;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.editor.StoryEditorRedoAction;
import edu.mit.story.ui.actions.editor.StoryEditorUndoAction;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.items.CommandHooks;
import edu.mit.story.ui.viewers.StoryElementComparer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class TagDataDetailsPage
extends HelperPage
implements IDetailsPage,
IModelListener,
IAdaptable,
ChangeListener {
    public static final String ID = TagDataDetailsPage.class.getName();
    private TreeViewer treeViewer;
    private IAction undoAction;
    private IAction redoAction;
    private IAction expandAction;
    private IAction collapseAction;
    private ActionGroup tagActions;
    private TagDataLabelProvider labelProvider;

    public void createControl(Composite parent) {
        this.labelProvider = new TagDataLabelProvider(this.getStoryEditor());
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setContentProvider((IContentProvider)new TagDataContentProvider(this.getStoryEditor()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setComparer((IElementComparer)StoryElementComparer.getInstance());
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.setControl((Control)this.treeViewer.getTree());
        CommandContributionItem deleteItem = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem editItem = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        this.undoAction = new StoryEditorUndoAction(this.getStoryEditor());
        this.redoAction = new StoryEditorRedoAction(this.getStoryEditor());
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        this.tagActions = new ChangeTagDataFeatureActionGroup(this.getStoryEditor(), (ISelectionProvider)this.treeViewer);
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener((IContributionItem)editItem, (IContributionItem)deleteItem){
            private final /* synthetic */ IContributionItem val$editItem;
            private final /* synthetic */ IContributionItem val$deleteItem;
            {
                this.val$editItem = iContributionItem;
                this.val$deleteItem = iContributionItem2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                ActionContext context = new ActionContext(TagDataDetailsPage.this.treeViewer.getSelection());
                TagDataDetailsPage.this.tagActions.setContext(context);
                ActionUtils.createPopupGroups((IMenuManager)manager);
                manager.appendToGroup("group.edit", this.val$editItem);
                manager.appendToGroup("group.edit", this.val$deleteItem);
                TagDataDetailsPage.this.tagActions.fillContextMenu(manager);
            }
        });
        this.getControl().setMenu(menu.createContextMenu(this.getControl()));
        this.getSite().registerContextMenu(String.valueOf(ID) + ".popupMenu", menu, (ISelectionProvider)this.treeViewer);
        ParsingPlugin.getDefault().getTagsetManager().addChangeListener((ChangeListener)this);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    public void modelChanged(StoryChangeEvent e) {
        if (this.treeViewer == null) {
            return;
        }
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        if (e.affects(TagRep.getInstance())) {
            this.treeViewer.refresh();
        }
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener((IModelListener)this);
        ParsingPlugin.getDefault().getTagsetManager().removeChangeListener((ChangeListener)this);
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void stateChanged(ChangeEvent e) {
        ITagset current;
        IFile file = (IFile)e.getSource();
        ITagset changed = ParsingPlugin.getDefault().getTagsetManager().createByPath(file.getFullPath().toPortableString());
        if (changed == (current = TagRep.getTagset((IStoryModel)this.getStoryEditor().getStoryModel()))) {
            this.treeViewer.refresh(true);
        }
    }
}

