/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.label;

import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.ui.ParsingUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class SentenceLabelProvider
extends StoryModelLabelProvider {
    private Image sentImg;

    public SentenceLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public SentenceLabelProvider(IHasStoryEditor editorProvider) {
        super(editorProvider);
    }

    public StyledString getStyledText(Object element) {
        long id = -1L;
        if (element instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = element instanceof IDesc ? (IDesc)element : null;
            if (SentenceRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                element = desc.getData();
            }
        }
        if (element instanceof ISentence) {
            ISentence sent = (ISentence)element;
            StyledString result = new StyledString();
            result.append(sent.getDisplayText());
            if (id >= 0L) {
                result.append(" (" + Long.toString(id) + ")", StyledString.DECORATIONS_STYLER);
            }
            return result;
        }
        return super.getStyledText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            return this.getSentenceImg();
        }
        if (element instanceof ISentence) {
            return this.getSentenceImg();
        }
        return super.getImage(element);
    }

    protected Image getSentenceImg() {
        if (this.sentImg == null) {
            this.sentImg = ParsingUIPlugin.getDefault().getImageRegistry().get("obj16/sentence.gif");
        }
        return this.sentImg;
    }
}

