/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.RequestDispatcherAdaptor;
import org.osgi.service.http.HttpContext;

public class ServletContextAdaptor
implements ServletContext {
    private ServletContext servletContext;
    HttpContext httpContext;
    private AccessControlContext acc;
    private ProxyContext proxyContext;
    static /* synthetic */ Class class$0;

    public ServletContextAdaptor(ProxyContext proxyContext, ServletContext servletContext, HttpContext httpContext, AccessControlContext acc) {
        this.servletContext = servletContext;
        this.httpContext = httpContext;
        this.acc = acc;
        this.proxyContext = proxyContext;
    }

    public Set getResourcePaths(String name) {
        if (name == null || !name.startsWith("/")) {
            return null;
        }
        try {
            Class<?> clazz = this.httpContext.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method getResourcePathsMethod = clazz.getMethod("getResourcePaths", classArray);
            if (!getResourcePathsMethod.isAccessible()) {
                ((AccessibleObject)getResourcePathsMethod).setAccessible(true);
            }
            return (Set)getResourcePathsMethod.invoke((Object)this.httpContext, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getAttribute(String attributeName) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.get(attributeName);
    }

    public Enumeration getAttributeNames() {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        return attributes.keys();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String attributeName) {
        Dictionary attributes = this.proxyContext.getContextAttributes(this.httpContext);
        attributes.remove(attributeName);
    }

    public String getMimeType(String name) {
        String mimeType = this.httpContext.getMimeType(name);
        return mimeType != null ? mimeType : this.servletContext.getMimeType(name);
    }

    public URL getResource(final String name) {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ServletContextAdaptor.this.httpContext.getResource(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            this.log(e.getException().getMessage(), e.getException());
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                this.log("Error opening stream for resource '" + name + "'", e);
            }
        }
        return null;
    }

    public ServletContext getContext(String arg0) {
        return this.servletContext.getContext(arg0);
    }

    public String getInitParameter(String arg0) {
        return this.servletContext.getInitParameter(arg0);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getNamedDispatcher(arg0));
    }

    public String getRealPath(String arg0) {
        return this.servletContext.getRealPath(arg0);
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return new RequestDispatcherAdaptor(this.servletContext.getRequestDispatcher(String.valueOf(this.proxyContext.getServletPath()) + arg0));
    }

    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public Servlet getServlet(String arg0) throws ServletException {
        return this.servletContext.getServlet(arg0);
    }

    public String getServletContextName() {
        return this.servletContext.getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.servletContext.getServletNames();
    }

    public Enumeration getServlets() {
        return this.servletContext.getServlets();
    }

    public void log(Exception arg0, String arg1) {
        this.servletContext.log(arg0, arg1);
    }

    public void log(String arg0, Throwable arg1) {
        this.servletContext.log(arg0, arg1);
    }

    public void log(String arg0) {
        this.servletContext.log(arg0);
    }

    public String getContextPath() {
        try {
            Method getContextPathMethod = this.servletContext.getClass().getMethod("getContextPath", null);
            return String.valueOf((String)getContextPathMethod.invoke((Object)this.servletContext, null)) + this.proxyContext.getServletPath();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

