/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.algorithm;

import edu.mit.story.core.algorithm.IAlgorithm;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.util.NotInitializedException;

public abstract class AbstractAlgorithm
extends Registered
implements IAlgorithm {
    private Object initLock = new Object();
    private boolean isInitialized = false;
    private IConfiguration config;
    private IConfigDescriptor configDesc;

    protected IConfigDescriptor createConfigurationDescriptor() {
        return null;
    }

    protected boolean doInit() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Object object = this.initLock;
        synchronized (object) {
            this.isInitialized = this.doInit();
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void dispose() {
    }

    public boolean configure(IConfiguration newConfig) {
        IConfiguration c = this.getConfiguration();
        if (c == null) {
            return false;
        }
        return c.configure(newConfig);
    }

    public IConfiguration getConfiguration() {
        IConfigDescriptor desc;
        if (this.config == null && (desc = this.getConfigurationDescriptor()) != null) {
            this.config = desc.createDefault();
        }
        return this.config;
    }

    public IConfigDescriptor getConfigurationDescriptor() {
        if (this.configDesc == null) {
            this.configDesc = this.createConfigurationDescriptor();
        }
        return this.configDesc;
    }

    protected void checkInit() {
        if (!this.isInitialized) {
            throw new NotInitializedException();
        }
    }
}

