/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.text.TextRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment
implements ISegment {
    private final String text;
    private final ImmutableDescSet descs;

    public Segment(Collection<? extends IDesc> specified, IStoryData data) {
        IDesc first = specified.iterator().next();
        DescSet specifiedDescs = new DescSet(first.getRep(), specified);
        this.descs = new ImmutableDescSet(specifiedDescs);
        this.text = TextRep.getPrettyText(this.descs, data);
    }

    public Segment(IHasPosition p, IRep rep, IStoryData data) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (rep == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        IDescSet descs = data.getDescriptions(rep);
        IDescSet subset = descs.openSet(p);
        IDescSet iDescSet = subset = subset.isEmpty() ? descs.closedSet(p) : subset;
        if (subset.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.descs = new ImmutableDescSet(rep, subset);
        this.text = TextRep.getPrettyText(subset, data);
    }

    @Override
    public IRep getRep() {
        return this.descs.getRep();
    }

    @Override
    public IDescSet getDescs() {
        return this.descs;
    }

    @Override
    public String getDisplayText() {
        return this.text;
    }

    @Override
    public int getLength() {
        return this.descs.getLength();
    }

    @Override
    public int getOffset() {
        return this.descs.getOffset();
    }

    @Override
    public int getRightOffset() {
        return this.descs.getRightOffset();
    }

    public String toString() {
        return String.valueOf(this.descs.toString()) + ", text=[" + this.getDisplayText() + "]";
    }

    @Override
    public IHasPosition getDisplayPosition() {
        return this.getDescs();
    }

    @Override
    public IHasPosition calculatePosition() {
        return this.getDescs();
    }

    @Override
    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDescSet newDescs = model.getData().getDescriptions(this.descs.getRep());
        HasPositionSet newSegment = new HasPositionSet();
        boolean changed = false;
        HashSet<SortedSet<String>> sourceSets = new HashSet<SortedSet<String>>(this.descs.size());
        for (IDesc oldDesc : this.descs) {
            SortedSet<String> profile;
            IDesc newDesc = newDescs.getDescription(oldDesc.getID());
            if (newDesc != oldDesc) {
                changed = true;
            }
            if (newDesc != null) {
                newSegment.add(newDesc);
            }
            if (newDesc == null || (profile = MergeMetaRep.extractMergeProfile(newDesc)).isEmpty()) continue;
            boolean add = true;
            Iterator i = sourceSets.iterator();
            while (i.hasNext()) {
                Set p = (Set)i.next();
                if (p.containsAll(profile)) {
                    add = false;
                    break;
                }
                if (!profile.containsAll(p)) continue;
                i.remove();
            }
            if (!add) continue;
            sourceSets.add(profile);
        }
        if (newSegment.isEmpty()) {
            return null;
        }
        SimplePosition pos = new SimplePosition(newSegment);
        for (IDesc d : newDescs.openSet(pos)) {
            if (newSegment.contains(d) || !MergeMetaRep.matches(sourceSets, d)) continue;
            changed |= newSegment.add(d);
        }
        if (!changed) {
            return this;
        }
        return new Segment(newSegment, model.getData());
    }

    public static boolean isValidSegmentPosition(IHasPosition p, IRep rep, IStoryData data) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (rep == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        IDescSet descs = data.getDescriptions(rep);
        if (descs.isEmpty()) {
            return false;
        }
        IDescSet subset = descs.openSet(p);
        subset = subset.isEmpty() ? descs.closedSet(p) : subset;
        IHasPosition range = PositionUtils.makePosition(subset);
        return PositionUtils.equalAsPositions(range, p);
    }

    public static String generateText(Collection<? extends ISegment> segments) {
        StringBuilder sb = new StringBuilder(128);
        Iterator<? extends ISegment> i = segments.iterator();
        while (i.hasNext()) {
            ISegment segment = i.next();
            sb.append(segment.getDisplayText());
            if (!i.hasNext()) continue;
            sb.append("...");
        }
        return sb.toString();
    }

    public static String serialize(ISegment segment) {
        return Segment.serialize(segment, true);
    }

    public static String serialize(ISegment segment, boolean longForm) {
        StringBuilder sb = new StringBuilder();
        if (longForm) {
            Segment.serializeLong(segment, sb);
        } else {
            Segment.serializeShort(segment, sb);
        }
        return sb.toString();
    }

    protected static void serializeShort(ISegment segment, StringBuilder sb) {
        sb.append(Long.toString(((IDesc)segment.getDescs().first()).getID()));
        sb.append('-');
        sb.append(Long.toString(((IDesc)segment.getDescs().last()).getID()));
    }

    protected static void serializeLong(ISegment segment, StringBuilder sb) {
        Iterator i = segment.getDescs().iterator();
        while (i.hasNext()) {
            sb.append(((IDesc)i.next()).getID());
            if (!i.hasNext()) continue;
            sb.append('~');
        }
    }

    public static ISegment reconstitute(String data, IRep rep, IStoryData source) {
        if (data.indexOf(45) > -1) {
            return Segment.reconstituteShort(data, rep, source);
        }
        return Segment.reconstituteLong(data, source);
    }

    protected static ISegment reconstituteShort(String data, IRep rep, IStoryData source) {
        int idx = data.indexOf(45);
        if (idx < 0) {
            return null;
        }
        int firstID = Integer.parseInt(data.substring(0, idx).trim());
        int lastID = Integer.parseInt(data.substring(idx + 1).trim());
        IDescSet descs = source.getDescriptions(rep);
        IDesc first = descs.getDescription(firstID);
        IDesc last = descs.getDescription(lastID);
        IHasPosition p = PositionUtils.combine(first, last);
        return new Segment(p, rep, source);
    }

    protected static ISegment reconstituteLong(String data, IStoryData source) {
        List<String> ids = BlockMapper.TILDE.reconstitute(data);
        ArrayList<IDesc> segment = new ArrayList<IDesc>(ids.size());
        for (String id : ids) {
            IDesc desc = source.getDescription(Long.parseLong(id));
            if (desc == null) continue;
            segment.add(desc);
        }
        return new Segment(segment, source);
    }

    public static IDescSet extractSegmentDescriptions(IHasSegments segs) {
        DescSet result = new DescSet(segs.getRep());
        for (ISegment seg : segs.getSegments()) {
            result.addAll(seg.getDescs());
        }
        return result;
    }

    @Override
    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ISegment.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ISegment tgtSegment = (ISegment)tgtData;
        return this.descs.equals(tgtSegment.getDescs(), model);
    }
}

