/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.descriptor;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.util.IFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DescriptorLabelFormatter implements IFormatter<IDescriptor>
{
    NAME_ONLY,
    ID_ONLY,
    NAME_PAREN_ID,
    ID_PAREN_NAME;

    private static final String leftParen = " (";
    private static final String rightParen = ")";

    @Override
    public String format(IDescriptor desc) {
        if (this == NAME_ONLY) {
            return desc.getName();
        }
        if (this == ID_ONLY) {
            return desc.getID();
        }
        if (this == NAME_PAREN_ID) {
            return String.valueOf(desc.getName()) + leftParen + desc.getID() + rightParen;
        }
        if (this == ID_PAREN_NAME) {
            return String.valueOf(desc.getID()) + leftParen + desc.getName() + rightParen;
        }
        return "";
    }

    public boolean isShowingIDs() {
        return this == ID_PAREN_NAME | this == ID_ONLY | this == NAME_PAREN_ID;
    }

    public boolean isShowingName() {
        return this == ID_PAREN_NAME | this == NAME_ONLY | this == NAME_PAREN_ID;
    }
}

