/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.element;

import edu.mit.story.core.desc.DescMultiSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.element.IStoryElementSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IPosition;
import edu.mit.story.core.position.IPositionSet;
import edu.mit.story.core.position.PositionSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import java.util.AbstractSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryElementSet
extends AbstractSet<IStoryElement>
implements IStoryElementSet {
    private static final long serialVersionUID = 8973437861678323950L;
    private IPositionSet fPositions = new PositionSet();
    private IRepSet fReps = new RepSet();
    private IDescMultiSet fDescs = new DescMultiSet();

    public Object getAdapter(Class adapter) {
        return null;
    }

    public StoryElementSet() {
    }

    public StoryElementSet(IRepSet repSet) {
        this.fReps.addAll(repSet);
    }

    public StoryElementSet(IDescMultiSet descs) {
        this.fDescs.addAll(descs);
    }

    public StoryElementSet(IPositionSet ps) {
        this.fPositions.addAll(ps);
    }

    public StoryElementSet(IRepSet repSet, IDescMultiSet descs, IPositionSet ps) {
        this.fPositions.addAll(ps);
        this.fReps.addAll(repSet);
        this.fDescs.addAll(descs);
    }

    @Override
    public IStoryElement compress() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.fPositions.isEmpty() & this.fReps.isEmpty() & this.fDescs.isEmpty()) {
            if (this.fPositions.size() == 1) {
                return (IStoryElement)this.fPositions.first();
            }
            return this.fPositions;
        }
        if (this.fPositions.isEmpty() & !this.fReps.isEmpty() & this.fDescs.isEmpty()) {
            if (this.fReps.size() == 1) {
                return (IStoryElement)this.fReps.first();
            }
            return this.fReps;
        }
        if (this.fPositions.isEmpty() & this.fReps.isEmpty() & !this.fDescs.isEmpty()) {
            if (this.fDescs.repSize() == 1) {
                return this.fDescs.descSetIterator().next();
            }
            return this.fDescs;
        }
        return this;
    }

    @Override
    public boolean involves(IRep rep) {
        return this.fReps.contains(rep) | this.fDescs.size(rep) > 0;
    }

    @Override
    public boolean involves(IHasPosition range) {
        if (!this.fPositions.closedSet(range).isEmpty()) {
            return true;
        }
        Iterator i = this.fDescs.repIterator();
        while (i.hasNext()) {
            IDescSet descSet = this.fDescs.getDescriptions((IRep)i.next());
            if (descSet == null || descSet.closedSet(range).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPositionSet getPositions() {
        return this.fPositions;
    }

    @Override
    public IDescMultiSet getDescriptions() {
        return this.fDescs;
    }

    @Override
    public IRepSet getRepresentations() {
        return this.fReps;
    }

    @Override
    public int size() {
        return this.fDescs.size() + this.fReps.size() + this.fPositions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fDescs.isEmpty() & this.fReps.isEmpty() & this.fPositions.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.fDescs.contains(o) | this.fReps.contains(o) | this.fPositions.contains(o);
    }

    @Override
    public Iterator<IStoryElement> iterator() {
        return new StoryElementSetIterator();
    }

    @Override
    public boolean add(IStoryElement e) {
        switch (e.getImplementationCode()) {
            case 3: {
                return this.fPositions.add((IPosition)e);
            }
            case 4: {
                return this.fPositions.addAll((IPositionSet)e);
            }
            case 5: {
                return this.fDescs.add((IDesc)((Object)e));
            }
            case 6: {
                return this.fDescs.addAll((IDescSet)e);
            }
            case 7: {
                return this.fDescs.addAll((IDescMultiSet)e);
            }
            case 1: {
                return this.fReps.add((IRep)e);
            }
            case 2: {
                return this.fReps.addAll((IRepSet)e);
            }
            case 9: {
                IStoryElementSet set = (IStoryElementSet)e;
                return this.add(set.getPositions()) | this.add(set.getDescriptions()) | this.add(set.getRepresentations());
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IStoryElement)) {
            return false;
        }
        switch (((IStoryElement)o).getImplementationCode()) {
            case 3: {
                return this.fPositions.remove((IPosition)o);
            }
            case 4: {
                return this.fPositions.removeAll((IPositionSet)o);
            }
            case 5: {
                return this.fDescs.remove((IDesc)o);
            }
            case 6: {
                return this.fDescs.removeAll((IDescSet)o);
            }
            case 7: {
                return this.fDescs.removeAll((IDescMultiSet)o);
            }
            case 1: {
                return this.fReps.remove((IRep)o);
            }
            case 2: {
                return this.fReps.removeAll((IRepSet)o);
            }
            case 9: {
                IStoryElementSet set = (IStoryElementSet)o;
                return this.remove(set.getPositions()) | this.remove(set.getDescriptions()) | this.remove(set.getRepresentations());
            }
            case 8: {
                IStoryModel provider = (IStoryModel)o;
                return this.removeAll(provider.getData());
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.fDescs.clear();
        this.fReps.clear();
        this.fPositions.clear();
    }

    @Override
    public final int getImplementationCode() {
        return 9;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IStoryElementSet;
    }

    @Override
    public String getSerializedData() {
        return this.fDescs.getSerializedData();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Representations:\n");
        if (this.fReps.isEmpty()) {
            sb.append("\t(none)");
        } else {
            for (IRep rep : this.fReps) {
                sb.append("\t" + rep.getID() + "\n");
            }
        }
        sb.append("\nDescriptions:\n");
        if (this.fDescs.isEmpty()) {
            sb.append("\t(none)");
        } else {
            for (IRep rep : this.fDescs.getSupported()) {
                IDescSet descs = this.fDescs.getDescriptions(rep);
                sb.append("\t" + rep.getID() + " : " + descs.size() + "\n");
            }
        }
        sb.append("\nPositions:\n");
        if (this.fPositions.isEmpty()) {
            sb.append("\t(none)");
        } else {
            sb.append("\t");
            sb.append(this.fPositions.size());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StoryElementSetIterator
    implements Iterator<IStoryElement> {
        Iterator<IRep> repItr;
        Iterator<IDesc> descItr;
        Iterator<IPosition> posItr;
        Iterator<?> lastCalled;

        protected StoryElementSetIterator() {
            this.repItr = StoryElementSet.this.fReps.iterator();
            this.descItr = StoryElementSet.this.fDescs.iterator();
            this.posItr = StoryElementSet.this.fPositions.iterator();
            this.lastCalled = null;
        }

        @Override
        public boolean hasNext() {
            return this.repItr.hasNext() | this.descItr.hasNext() | this.posItr.hasNext();
        }

        @Override
        public IStoryElement next() {
            if (this.repItr.hasNext()) {
                this.lastCalled = this.repItr;
                return this.repItr.next();
            }
            this.lastCalled = this.posItr;
            return this.posItr.next();
        }

        @Override
        public void remove() {
            if (this.lastCalled == null) {
                throw new IllegalStateException("next() not yet called");
            }
            this.lastCalled.remove();
        }
    }
}

