/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.property.IProperty;
import edu.mit.story.core.property.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapper
implements IValueMapper<IProperty> {
    public static String keyValueSeparator = "==";
    public static String entrySeparator = ",,";
    private static Pattern keyValueSepPattern = Pattern.compile(keyValueSeparator);
    private static Pattern entrySepPattern = Pattern.compile(entrySeparator);
    private static PropertyMapper fInstance = null;

    public static PropertyMapper getInstance() {
        if (fInstance == null) {
            fInstance = new PropertyMapper();
        }
        return fInstance;
    }

    @Override
    public List<IProperty> reconstitute(String value) {
        String[] entries;
        ArrayList<IProperty> result = new ArrayList<IProperty>();
        String[] stringArray = entries = entrySepPattern.split(value, -1);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] parts = keyValueSepPattern.split(entry, -1);
            if (parts.length == 2) {
                result.add(new Property(parts[0], parts[1]));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String serialize(Collection<? extends IProperty> objects) {
        StringBuffer sb = new StringBuffer();
        if (objects != null) {
            Iterator<? extends IProperty> i = objects.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                sb.append((String)entry.getKey());
                sb.append(keyValueSeparator);
                sb.append((String)entry.getValue());
                if (!i.hasNext()) continue;
                sb.append(entrySeparator);
            }
        }
        return sb.toString();
    }
}

