/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveRepresentationsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepComparator;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRepsWithConfigChange
extends AbstractModelChange {
    public final List<IRep> addReps;
    public final List<IConfiguration> repConfigs;
    public final IRepConfiguration factConfigs;

    public AddRepsWithConfigChange(IRep rep, IConfiguration repConfig, IRepConfiguration factConfig) {
        super(StoryMessages.CHANGE_NAME_AddRepresentationsWithConfig);
        if (rep == null) {
            this.addReps = Collections.emptyList();
        } else {
            ArrayList<IRep> hidden = new ArrayList<IRep>();
            hidden.add(rep);
            this.addReps = Collections.unmodifiableList(hidden);
        }
        if (repConfig == null) {
            this.repConfigs = Collections.emptyList();
        } else {
            ArrayList<IConfiguration> hiddenConf = new ArrayList<IConfiguration>();
            hiddenConf.add(repConfig);
            this.repConfigs = Collections.unmodifiableList(hiddenConf);
        }
        this.factConfigs = factConfig;
    }

    public AddRepsWithConfigChange(Collection<? extends IRep> reps, Collection<? extends IConfiguration> configs, IRepConfiguration factConfig) {
        super(StoryMessages.CHANGE_NAME_AddRepresentationsWithConfig);
        if (reps == null || reps.isEmpty()) {
            this.addReps = Collections.emptyList();
        } else {
            TreeSet<IRep> orderedReps = new TreeSet<IRep>(RepComparator.getInstance());
            orderedReps.addAll(reps);
            ArrayList<IRep> hidden = new ArrayList<IRep>(orderedReps);
            this.addReps = Collections.unmodifiableList(hidden);
        }
        if (configs == null || configs.isEmpty()) {
            this.repConfigs = Collections.emptyList();
        } else {
            ArrayList<? extends IConfiguration> hiddenConf = new ArrayList<IConfiguration>(configs);
            this.repConfigs = Collections.unmodifiableList(hiddenConf);
        }
        this.factConfigs = factConfig;
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        IConfiguration config2;
        ArrayList<IRep> added = null;
        IStoryData descs = model.getData();
        for (IRep rep : this.addReps) {
            if (!descs.addSupport(rep)) continue;
            if (added == null) {
                added = new ArrayList<IRep>();
            }
            added.add(rep);
        }
        if (added == null) {
            return null;
        }
        for (IConfiguration config2 : this.repConfigs) {
            descs.setConfiguration(config2);
        }
        config2 = null;
        String nameFactory = null;
        IFactoryManager fm = StoryPlugin.getDefault().getFactoryManager();
        for (IRep rep : this.addReps) {
            if (this.factConfigs != null) {
                config2 = this.factConfigs.getConfiguration(rep.getID());
                nameFactory = (String)this.factConfigs.get(rep.getID());
            }
            IFactoryDescriptor desc = nameFactory != null ? (IFactoryDescriptor)fm.getDescriptor(nameFactory) : (IFactoryDescriptor)fm.getPlatformDefault(rep);
            IDescFactory factory = config2 != null ? (IDescFactory)desc.create(config2) : (IDescFactory)desc.create();
            model.setFactory(factory);
            factory.init(model);
            SimplePosition all = new SimplePosition(0, model.getLength());
            IDescSet newDescs = factory.calculateDescs(all, model);
            if (newDescs == null) continue;
            model.getData().getDescriptions(rep).addAll(newDescs);
        }
        StoryChangeEvent changeEv = new StoryChangeEvent(source, model, new RepSet(this.addReps), new Change(Flag.REP_ADDED, (IHasPosition[])new IStoryModel[]{model}), (IModelChange)this, (IModelChange)new RemoveRepresentationsChange(this.addReps));
        return changeEv;
    }
}

