/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.NotifyingMessageProvider;
import edu.mit.story.core.util.IClearable;
import edu.mit.story.core.validation.Message;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

public class MessageProviderManager
extends NotifyingMessageProvider
implements ChangeListener {
    private final Map<INotifyingMessageProvider, ChildData> children = new LinkedHashMap<INotifyingMessageProvider, ChildData>(2);
    private IMessageProvider defaultMessage = Message.NO_MESSAGE;
    private IMessageProvider allClearedMessage = null;

    public MessageProviderManager() {
        this(null);
    }

    public MessageProviderManager(ChangeListener client) {
        this(Message.NO_MESSAGE, client);
    }

    public MessageProviderManager(IMessageProvider defaultMessage, ChangeListener client) {
        this.defaultMessage = defaultMessage == null ? Message.NO_MESSAGE : defaultMessage;
        this.addChangeListener(client);
    }

    public void setAllClearedMesage(IMessageProvider allClearedMessage) {
        this.allClearedMessage = allClearedMessage;
    }

    public IMessageProvider getAllClearedMessage() {
        return this.allClearedMessage;
    }

    public void setDefaultMesage(IMessageProvider defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public IMessageProvider getDefaultMessage() {
        return this.defaultMessage;
    }

    public IMessageProvider getFixedMessage() {
        return new Message(this.getMessage(), this.getMessageType());
    }

    protected IMessageProvider calculateMessage() {
        String newMsg = null;
        int newType = 0;
        boolean allCleared = true;
        for (Map.Entry<INotifyingMessageProvider, ChildData> entry : this.children.entrySet()) {
            int type;
            ChildData data = entry.getValue();
            boolean isCleared = data.getClearable() == null ? false : data.getClearable().isCleared();
            allCleared &= isCleared;
            if (isCleared && data.shouldIgnoreWhenCleared() || (type = entry.getKey().getMessageType()) <= newType) continue;
            newType = type;
            newMsg = entry.getKey().getMessage();
        }
        if (allCleared && this.allClearedMessage != null) {
            return this.allClearedMessage;
        }
        return newType == 0 ? this.defaultMessage : new Message(newMsg, newType);
    }

    public void add(INotifyingMessageProvider child) {
        this.add(child, false);
    }

    public void add(INotifyingMessageProvider child, boolean ignoreWhenCleared) {
        if (this.children.containsKey(child)) {
            return;
        }
        IClearable value = child instanceof IClearable ? (IClearable)((Object)child) : null;
        this.children.put(child, new ChildData(value, ignoreWhenCleared));
        child.addChangeListener(this);
        this.setOutOfSync();
    }

    public void remove(INotifyingMessageProvider child) {
        this.children.remove(child);
        child.removeChangeListener(this);
        this.setOutOfSync();
    }

    public void stateChanged(ChangeEvent e) {
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    protected String getDebugName() {
        if (this.listeners.isEmpty()) {
            return this.toString();
        }
        return String.valueOf(this.listeners.getListeners()[0].toString()) + ":" + this.toString();
    }

    protected class ChildData {
        private final IClearable clearable;
        private final boolean ignoreWhenCleared;

        public ChildData(IClearable clearable, boolean ignoreWhenCleared) {
            this.clearable = clearable;
            this.ignoreWhenCleared = ignoreWhenCleared;
        }

        public boolean shouldIgnoreWhenCleared() {
            return this.ignoreWhenCleared;
        }

        public IClearable getClearable() {
            return this.clearable;
        }
    }
}

