/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.NotifyingIterator;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingSet<E>
extends AbstractSet<E> {
    protected final INotifyCollectionCallback<E> callback;
    protected final Set<E> backingSet;

    public NotifyingSet(INotifyCollectionCallback<E> callback) {
        this(new HashSet(), callback);
    }

    protected NotifyingSet(Set<E> backingSet, INotifyCollectionCallback<E> callback) {
        if (backingSet == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        this.backingSet = backingSet;
        this.callback = callback;
    }

    protected void notifyAdd(E added) {
        this.callback.elementAdded(added);
    }

    protected void notifyRemove(E removed) {
        this.callback.elementRemoved(removed);
    }

    @Override
    public boolean add(E o) {
        boolean modified = this.backingSet.add(o);
        if (modified) {
            this.notifyAdd(o);
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        return this.backingSet.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.backingSet.remove(o);
        if (removed) {
            this.notifyRemove(o);
        }
        return removed;
    }

    @Override
    public Iterator<E> iterator() {
        return new NotifyingIterator<E>(this.backingSet.iterator(), this.callback);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }
}

