/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.property.CorpusConfiguration;
import edu.mit.story.core.property.ICorpusConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IObjectExporter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusConfigExporter
implements IObjectExporter<ICorpusConfiguration> {
    public static final String TAG_REPRESENTATIONS = "representations";
    public static final String ATTR_REQUIRED = "required";
    private static CorpusConfigExporter instance = null;
    private DOMImplementation domImpl;

    public static CorpusConfigExporter getInstance() {
        if (instance == null) {
            instance = new CorpusConfigExporter();
        }
        return instance;
    }

    protected CorpusConfigExporter() {
    }

    @Override
    public Document exportToXML(ICorpusConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        Document doc = this.createEmptyDocument();
        Node headNode = doc.getElementsByTagName(TAG_REPRESENTATIONS).item(0);
        StoryModelExporter exporter = StoryModelExporter.getInstance();
        Iterator<IRep> i = config.repIterator();
        while (i.hasNext()) {
            IRep rep = i.next();
            Element repNode = exporter.exportRep(headNode, rep, config.getRepConfiguration(rep), doc);
            if (repNode == null) continue;
            String reqKey = CorpusConfiguration.getRequiredKey(rep);
            if (Boolean.parseBoolean((String)config.get(reqKey))) {
                repNode.setAttribute(ATTR_REQUIRED, Boolean.toString(true));
            }
            Element factoryNode = doc.createElement("factory");
            repNode.appendChild(factoryNode);
            factoryNode.setAttribute("id", config.getFactoryID(rep));
            exporter.exportConfig(factoryNode, config.getFactoryConfiguration(rep), doc);
        }
        doc.normalizeDocument();
        return doc;
    }

    protected Document createEmptyDocument() {
        if (this.domImpl == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            if (builder == null) {
                return null;
            }
            this.domImpl = builder.getDOMImplementation();
        }
        DocumentType type = this.domImpl.createDocumentType(TAG_REPRESENTATIONS, null, null);
        return this.domImpl.createDocument(null, TAG_REPRESENTATIONS, type);
    }
}

