/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.property;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IModelConfiguration;
import edu.mit.story.core.property.IPropertyDescriptor;
import edu.mit.story.core.property.PropertyDescriptor;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.DescriptorListValidator;
import edu.mit.story.core.validation.EmptyValidator;
import edu.mit.story.core.validation.IValidator;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class ModelConfiguration
extends RepConfiguration
implements IModelConfiguration {
    private String corpus;

    public ModelConfiguration(IDescriptor d) {
        super(d);
    }

    public ModelConfiguration(IModelConfiguration c) {
        super(c);
    }

    public ModelConfiguration clone() {
        return new ModelConfiguration(this);
    }

    public boolean addSupport(IRep rep) {
        if (!super.addSupport(rep)) {
            return false;
        }
        this.putProperty(this.generateFactoryDescriptor(rep));
        return true;
    }

    public boolean removeSupport(IRep rep) {
        if (!super.removeSupport(rep)) {
            return false;
        }
        this.removeProperty(ModelConfiguration.getFactoryKey(rep));
        return true;
    }

    protected IPropertyDescriptor generateFactoryDescriptor(IRep rep) {
        String defaultStr;
        IValidator<String> v;
        IFactoryManager m = StoryPlugin.getDefault().getFactoryManager();
        List ds = m.getDescriptors(rep);
        if (ds == null || ds.isEmpty()) {
            v = new EmptyValidator();
            defaultStr = "";
        } else {
            v = new DescriptorListValidator(ds, true);
            IFactoryDescriptor d = (IFactoryDescriptor)m.getPlatformDefault(rep);
            defaultStr = d.getID();
        }
        return new PropertyDescriptor(ModelConfiguration.getFactoryKey(rep), rep.getName(), rep.getDescription(), defaultStr, v, true);
    }

    public String getFactoryID(IRep key) {
        return this.get(ModelConfiguration.getFactoryKey(key));
    }

    public IConfiguration getFactoryConfiguration(IRep key) {
        return this.getConfigurations().get(ModelConfiguration.getFactoryKey(key));
    }

    public String putFactoryID(IRep rep, String id) {
        String key = ModelConfiguration.getFactoryKey(rep);
        String oldID = this.put(key, id);
        IConfiguration currConfig = this.getConfigurations().get(key);
        if (currConfig != null && !currConfig.getID().equals(id)) {
            this.getConfigurations().put(key, null);
        }
        return oldID;
    }

    public IConfiguration putFactoryConfiguration(IRep rep, IConfiguration config) {
        String key = ModelConfiguration.getFactoryKey(rep);
        this.put(key, config.getID());
        return this.getConfigurations().put(key, config);
    }

    public static String getFactoryKey(IRep rep) {
        return String.valueOf(rep.getID()) + ".factory";
    }

    public static IDescriptor createFactoryConfigDescriptor(IProject project) {
        return new Descriptor(project.getFullPath().toPortableString(), String.valueOf(project.getName()) + " Factory Configuration", "");
    }

    public static IDescriptor createBuilderConfigDescriptor(IProject project) {
        return new Descriptor(project.getFullPath().toPortableString(), String.valueOf(project.getName()) + " Builder Configuration", "");
    }

    public String getCorpus() {
        return this.corpus;
    }

    public void setCorpus(String corpus) {
        this.corpus = corpus;
    }
}

