/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.IUtilityClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepUtils
implements IUtilityClass {
    private RepUtils() {
    }

    public static boolean isLegalDataType(IRep rep, Object data) {
        if (data == null) {
            return false;
        }
        return rep.getDataFormat().isAssignableFrom(data.getClass());
    }

    public static boolean equal(IRep one, IRep two) {
        return one.getID().equals(two.getID());
    }

    public static int compare(IRep one, IRep two) {
        if (one.getDepth() != two.getDepth()) {
            return one.getDepth() - two.getDepth();
        }
        return one.getID().compareTo(two.getID());
    }

    public static String toString(IRep rep) {
        return rep.getID();
    }

    public static int hashCode(IRep rep) {
        return rep.getID().hashCode() * 31;
    }

    public static IRepSet closeWithAntecedents(Collection<? extends IRep> reps) {
        RepSet result = new RepSet(reps);
        HashSet<IRep> add = new HashSet<IRep>();
        for (IRep rep : result) {
            add.addAll(RepUtils.getAllAntecedents(rep));
        }
        result.addAll(add);
        return result;
    }

    public static IRepSet closeWithDependents(Collection<? extends IRep> reps, IRepSupporter supporter) {
        RepSet result = new RepSet(reps);
        result.addAll(RepUtils.getAllDependents(reps, supporter));
        return result;
    }

    public static IRepSet extractRepresentations(Collection<? extends IDesc> c) {
        if (c instanceof IDescSet) {
            RepSet reps = new RepSet();
            reps.add(((IDescSet)c).getRep());
            return reps;
        }
        if (c instanceof IDescMultiSet) {
            return ((IDescMultiSet)c).getSupported();
        }
        RepSet reps = new RepSet();
        for (IDesc iDesc : c) {
            reps.add(iDesc.getRep());
        }
        return reps;
    }

    public static boolean hasAllAntecedents(IRep rep, IRepSupporter supporter) {
        if (rep == null | supporter == null) {
            return false;
        }
        Iterator<IRep> i = rep.anteIterator();
        while (i.hasNext()) {
            if (supporter.supports(i.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyDependents(IRep rep, IRepSupporter supporter) {
        if (rep == null | supporter == null) {
            return false;
        }
        Iterator<IRep> i = supporter.repIterator();
        while (i.hasNext()) {
            if (!i.next().dependsOn(rep)) continue;
            return false;
        }
        return true;
    }

    public static boolean canAddConsistently(IRep rep, IRepSupporter supporter) {
        if (rep == null | supporter == null) {
            return false;
        }
        return RepUtils.hasAllAntecedents(rep, supporter) & !supporter.supports(rep);
    }

    public static boolean canAddAllConsistently(Collection<IRep> reps, IRepSupporter supporter) {
        if (reps == null | supporter == null) {
            return false;
        }
        if (reps.isEmpty()) {
            return true;
        }
        RepSet toAdd = new RepSet(reps);
        IRepSet supportedReps = supporter.getSupported();
        for (IRep add : toAdd) {
            if (!RepUtils.hasAllAntecedents(add, supportedReps)) {
                return false;
            }
            supportedReps.add(add);
        }
        for (IRep rep : reps) {
            if (supporter.supports(rep)) continue;
            return false;
        }
        return false;
    }

    public static boolean canRemove(IRep rep, IRepSupporter supporter) {
        if (rep == null | supporter == null) {
            return false;
        }
        return RepUtils.hasAllAntecedents(rep, supporter) & !supporter.supports(rep);
    }

    public static IRepSet getAllDependents(Collection<? extends IRep> reps, IRepSupporter supporter) {
        RepSet result = new RepSet();
        for (IRep iRep : reps) {
            result.addAll(RepUtils.getAllDependents(iRep, supporter));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static IRepSet getAllDependents(IRep rep, IRepSupporter supporter) {
        queue = new ArrayList<IRep>();
        queue.addAll(RepUtils.getImmediateDependents(rep, supporter));
        result = new RepSet();
        if (!queue.isEmpty()) ** GOTO lbl11
        return result;
lbl-1000:
        // 1 sources

        {
            next = (IRep)queue.remove(0);
            if (!result.add(next)) continue;
            queue.addAll(RepUtils.getImmediateDependents(next, supporter));
lbl11:
            // 3 sources

            ** while (!queue.isEmpty())
        }
lbl12:
        // 1 sources

        return result;
    }

    public static IRepSet getImmediateDependents(IRep rep, IRepSupporter supporter) {
        RepSet result = new RepSet();
        if (rep == null | supporter == null) {
            return result;
        }
        if (!supporter.supports(rep)) {
            return result;
        }
        Iterator<IRep> i = supporter.repIterator();
        while (i.hasNext()) {
            IRep supRep = i.next();
            if (!supRep.dependsOn(rep)) continue;
            result.add(supRep);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static IRepSet getAllAntecedents(IRep rep) {
        queue = new ArrayList<IRep>();
        queue.addAll(rep.getAntecedents());
        result = new RepSet();
        if (!queue.isEmpty()) ** GOTO lbl11
        return result;
lbl-1000:
        // 1 sources

        {
            next = (IRep)queue.remove(0);
            if (!result.add(next)) continue;
            queue.addAll(next.getAntecedents());
lbl11:
            // 3 sources

            ** while (!queue.isEmpty())
        }
lbl12:
        // 1 sources

        return result;
    }

    public static IRepSet getRoots(IRepSupporter supporter) {
        RepSet result = new RepSet();
        Iterator<IRep> i = supporter.repIterator();
        while (i.hasNext()) {
            IRep rep = i.next();
            if (rep.antecedentCount() != 0) continue;
            result.add(rep);
        }
        return result;
    }

    public static IRepSet toRepresentationSet(Collection<? extends IRep> reps) {
        if (reps instanceof IRepSet) {
            return (IRepSet)reps;
        }
        RepSet result = new RepSet(reps);
        return result;
    }
}

