/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text.rules;

import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.core.rep.text.problems.TextTilingProblem;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextTilingRule
extends AbstractBuildRule {
    public TextTilingRule() {
        super(TextRep.getInstance());
    }

    @Override
    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDescSet descs = model.getData().getDescriptions(TextRep.getInstance());
        Iterator i = descs.iterator();
        boolean ok = true;
        IDesc next = null;
        int lastIndex = 0;
        while (i.hasNext()) {
            next = (IDesc)i.next();
            if (next.getOffset() != lastIndex) {
                ok = false;
                break;
            }
            lastIndex = next.getRightOffset();
        }
        if (ok && lastIndex == model.getLength()) {
            return null;
        }
        ICharStore text = CharRep.extractCharStore(model.getData());
        StringBuilder sb = new StringBuilder(text.getLength());
        int idx = 0;
        while (idx < lastIndex) {
            sb.append('1');
            ++idx;
        }
        idx = lastIndex;
        while (idx < text.getLength()) {
            sb.append('0');
            ++idx;
        }
        if (!ok) {
            this.mark(next, sb);
        }
        while (i.hasNext()) {
            this.mark((IHasPosition)i.next(), sb);
        }
        HasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
        char type = '1';
        int offset = -1;
        int idx2 = 0;
        while (idx2 < sb.length()) {
            char c = sb.charAt(idx2);
            if (c != '1' && offset == -1) {
                offset = idx2;
                type = c;
            } else if (c != type && offset != -1) {
                result.add(new TextTilingProblem(type == '0', offset, idx2, this.getID()));
                offset = c == '1' ? -1 : idx2;
                type = c;
            }
            ++idx2;
        }
        if (offset != -1) {
            result.add(new TextTilingProblem(type == '0', offset, text.getLength(), this.getID()));
        }
        return result;
    }

    protected void mark(IHasPosition p, StringBuilder sb) {
        int i = p.getOffset();
        while (i < p.getRightOffset()) {
            char c = sb.charAt(i);
            if (c == '0') {
                sb.setCharAt(i, '1');
            } else if (c == '1') {
                sb.setCharAt(i, '2');
            }
            ++i;
        }
    }
}

