/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.IStoryConstants;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.validation.IDescriptorListValidator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorListValidator
implements IDescriptorListValidator<String> {
    protected boolean isRestricted;
    protected List<? extends IDescriptor> descriptors;
    List<String> unmodifiableValues;
    List<IDescriptor> unmodifiableDescriptors;

    public DescriptorListValidator(List<? extends IDescriptor> descriptors, boolean restricted) {
        this.isRestricted = restricted;
        this.descriptors = descriptors == null ? null : new ArrayList<IDescriptor>(descriptors);
    }

    @Override
    public List<String> getValueList() {
        if (this.unmodifiableValues == null) {
            this.unmodifiableValues = new ValueViewList();
        }
        return this.unmodifiableValues;
    }

    @Override
    public List<IDescriptor> getDescriptors() {
        if (this.descriptors == null) {
            return null;
        }
        if (this.unmodifiableDescriptors == null) {
            this.unmodifiableDescriptors = Collections.unmodifiableList(this.descriptors);
        }
        return this.unmodifiableDescriptors;
    }

    @Override
    public boolean isRestrictedToList() {
        return this.isRestricted;
    }

    @Override
    public IMessageProvider validate(String value) {
        if (value == null) {
            return IStoryConstants.noNullValues;
        }
        for (IDescriptor iDescriptor : this.descriptors) {
            if (!iDescriptor.getID().equals(value)) continue;
            return null;
        }
        return this.isRestricted ? IStoryConstants.invalidValue : this.doValidate(value);
    }

    protected IMessageProvider doValidate(String value) {
        return null;
    }

    public boolean isValueIDs() {
        return true;
    }

    @Override
    public boolean isValid(String value) {
        return this.validate(value).getMessageType() != 3;
    }

    @Override
    public boolean allowsInitialInvalidValue() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueViewList
    extends AbstractList<String> {
        protected ValueViewList() {
        }

        @Override
        public String get(int index) {
            return DescriptorListValidator.this.getDescriptors().get(index).getID();
        }

        @Override
        public int size() {
            return DescriptorListValidator.this.getDescriptors().size();
        }
    }
}

