/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.BaseValidator;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostnameValidator
extends BaseValidator<String> {
    private static final char period = '.';
    private static final char hyphen = '-';

    @Override
    public IMessageProvider validate(String hostname) {
        if (StringUtils.isNullorZero(hostname)) {
            return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameCannotBeEmpty);
        }
        if (hostname.length() > 255) {
            return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameHasLessThan256Chars);
        }
        if (hostname.charAt(0) == '.') {
            return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameCannotBeginWithPeriod);
        }
        if (hostname.charAt(hostname.length() - 1) == '.') {
            return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameCannotEndWithPeriod);
        }
        String[] labels = hostname.split("\\x2E");
        if (labels.length == 0) {
            labels = new String[]{hostname};
        }
        if (labels.length > 127) {
            return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameHasLessThan128Blocks);
        }
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label.length() > 63) {
                return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameBlockLessThan64Chars);
            }
            int i = 0;
            while (i < label.length()) {
                char c = label.charAt(i);
                if (!(Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c) || c == '-')) {
                    return this.bind(StoryMessages.MSG_HostnameNotValid, hostname, StoryMessages.MSG_HostnameIllegalCharacter);
                }
                ++i;
            }
            ++n2;
        }
        return null;
    }
}

