/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.changes;

import edu.mit.parsing.core.rep.colloc.Colloc;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.AssignPOSChange;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.stem.AssignStemChange;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.wordnet.core.WordnetMessages;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.changes.AssignSenseChange;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DisambiguationChange
extends AbstractModelChange {
    private final long wordID;
    private final Set<Long> tokenIDs;
    private final ISenseAssignment choice;
    private final IDisambiguationModel.AssignmentType type;
    private final IStemData stem;
    private final IPosData pos;
    private final List<ITiming> timings;

    public DisambiguationChange(IDisambiguationModel model) {
        super(WordnetMessages.CHANGE_NAME_Disambiguation);
        if (model == null) {
            throw new NullPointerException();
        }
        IBaseWordInfo info = model.getCurrentInfo();
        this.wordID = model.getWordDesc().getID();
        this.choice = model.getChosenSense();
        this.type = model.getAssignmentType();
        this.stem = info.getStem();
        this.pos = info.getPosTag();
        this.timings = Collections.unmodifiableList(new ArrayList<ITiming>(model.getTimingList()));
        IDescSet ds = Segment.extractSegmentDescriptions((IHasSegments)model.getWordModel());
        HashSet<Long> ids = new HashSet<Long>(ds.size());
        for (IDesc d : ds) {
            ids.add(d.getID());
        }
        this.tokenIDs = Collections.unmodifiableSet(ids);
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        LinkedList<Object> changes;
        block8: {
            IDesc oldWord;
            block9: {
                IDesc newWord;
                block7: {
                    oldWord = model.getData().getDescription(this.wordID);
                    if (oldWord == null) {
                        return null;
                    }
                    IStoryData data = model.getData();
                    DescSet newTokens = new DescSet(TokenRep.getInstance());
                    for (Long id : this.tokenIDs) {
                        IDesc token = data.getDescription(id.longValue());
                        if (token == null) continue;
                        newTokens.add((Object)token);
                    }
                    newWord = oldWord;
                    if (!Colloc.getWordTokens((IDesc)oldWord).equals((Object)newTokens)) {
                        Colloc colloc = new Colloc((Collection)newTokens);
                        newWord = new Desc(model.getNextID(), CollocRep.getInstance(), colloc.calculatePosition(), (IData)colloc, null);
                        newWord.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), newWord, (IMetaData)Origin.USER_SPECIFIED));
                        for (ITiming timing : this.timings) {
                            newWord.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), newWord, (IMetaData)timing));
                        }
                    }
                    changes = new LinkedList<Object>();
                    if (newWord != oldWord) {
                        changes.add(new AddDescriptionsChange(newWord));
                    }
                    changes.add(new AssignPOSChange(this.pos, newWord, this.timings));
                    changes.add(new AssignStemChange(this.stem, newWord, this.timings));
                    if (this.type != IDisambiguationModel.AssignmentType.NORMAL) break block7;
                    if (oldWord != newWord) {
                        changes.add((Object)new AssignSenseChange(null, oldWord, this.timings));
                    }
                    changes.add((Object)new AssignSenseChange(this.choice, newWord, this.timings));
                    break block8;
                }
                if (this.type != IDisambiguationModel.AssignmentType.NO_SENSE) break block9;
                if (oldWord != newWord) {
                    changes.add((Object)new AssignSenseChange(null, oldWord, this.timings));
                }
                changes.add((Object)new AssignSenseChange((ISenseAssignment)new SenseAssignment(null, null), newWord, this.timings));
                break block8;
            }
            if (this.type != IDisambiguationModel.AssignmentType.DELETE) break block8;
            changes.add((Object)new AssignSenseChange(null, oldWord, this.timings));
        }
        return new CompositeModelChange(changes).apply(source, model);
    }
}

