/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.rules;

import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.problems.MismatchedPOSTagProblem;
import edu.mit.wordnet.core.rep.sense.problems.MissingPOSTagProblem;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSensePOSRule
extends AbstractBuildRule {
    public CheckSensePOSRule() {
        super(SenseRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> missing = new HashSet<IDesc>();
        HashSet<IDesc> mismatched = new HashSet<IDesc>();
        IDescSet senseDescs = model.getData().getDescriptions(SenseRep.getInstance());
        for (IDesc senseDesc : senseDescs) {
            ISense sense = (ISense)senseDesc.getData();
            IDesc posDesc = sense.getPOSDesc();
            if (posDesc == null) {
                missing.add(senseDesc);
                continue;
            }
            if (WordnetUtils.matches(senseDesc)) continue;
            mismatched.add(senseDesc);
        }
        if (mismatched.isEmpty() && missing.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : mismatched) {
            result.add((Object)new MismatchedPOSTagProblem(d, this.getID()));
        }
        for (IDesc d : missing) {
            result.add((Object)new MissingPOSTagProblem(d, this.getID()));
        }
        return result;
    }
}

