/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFMetadataTransport {
    private static final String SERVER_REDIRECT = "Server redirected too many times";
    private static final int LOGIN_RETRIES = 3;
    private static final ProtocolException ERROR_401 = new ProtocolException();
    private static ECFMetadataTransport instance;
    private final ServiceTracker retrievalFactoryTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static synchronized ECFMetadataTransport getInstance() {
        if (instance == null) {
            instance = new ECFMetadataTransport();
        }
        return instance;
    }

    private ECFMetadataTransport() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.retrievalFactoryTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.retrievalFactoryTracker.open();
    }

    public IStatus download(String url, OutputStream destination, IProgressMonitor monitor) {
        try {
            IConnectContext context = this.getConnectionContext(url, false);
            int i = 0;
            while (i < 3) {
                try {
                    return this.performDownload(url, destination, context, monitor);
                }
                catch (ProtocolException e) {
                    if (e == ERROR_401) {
                        context = this.getConnectionContext(url, true);
                    }
                    ++i;
                }
            }
        }
        catch (UserCancelledException userCancelledException) {
            return Status.CANCEL_STATUS;
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1007, NLS.bind((String)Messages.io_failedRead, (Object)url), null);
    }

    public IStatus performDownload(String toDownload, OutputStream target, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.retrievalFactoryTracker.getService();
        if (factory == null) {
            return new Status(4, "org.eclipse.equinox.p2.metadata.repository", NLS.bind((String)Messages.io_failedRead, (Object)toDownload));
        }
        return this.transfer((IRetrieveFileTransferContainerAdapter)factory.newInstance(), toDownload, target, context, monitor);
    }

    public long getLastModified(URL location) throws ProvisionException {
        String locationString = location.toExternalForm();
        try {
            IConnectContext context = this.getConnectionContext(locationString, false);
            int i = 0;
            while (i < 3) {
                try {
                    return this.doGetLastModified(locationString, context);
                }
                catch (ProtocolException e) {
                    if (ERROR_401 == e) {
                        context = this.getConnectionContext(locationString, true);
                    }
                }
                catch (Exception e) {
                    e.getMessage();
                }
                ++i;
            }
        }
        catch (UserCancelledException userCancelledException) {
            throw new OperationCanceledException();
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1007, NLS.bind((String)Messages.io_failedRead, (Object)locationString), null));
    }

    private long doGetLastModified(String location, IConnectContext context) throws ProtocolException {
        IRemoteFileSystemBrowserContainerAdapter adapter;
        IContainer container;
        try {
            container = ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException containerCreateException) {
            return 0L;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter((Class)clazz)) == null) {
            return 0L;
        }
        IRemoteFile remoteFile = this.checkFile(adapter, location, context);
        if (remoteFile == null) {
            return 0L;
        }
        return remoteFile.getInfo().getLastModified();
    }

    public IConnectContext getConnectionContext(String xmlLocation, boolean prompt) throws UserCancelledException, ProvisionException {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        IPath hostLocation = new Path(xmlLocation).removeLastSegments(1);
        try {
            nodeKey = URLEncoder.encode(hostLocation.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            nodeKey = URLEncoder.encode(hostLocation.toString());
        }
        String nodeName = "org.eclipse.equinox.p2.repository/" + nodeKey;
        ISecurePreferences prefNode = null;
        if (securePreferences.nodeExists(nodeName)) {
            prefNode = securePreferences.node(nodeName);
        }
        if (!prompt) {
            String password;
            String username;
            block18: {
                if (prefNode == null) {
                    return null;
                }
                try {
                    username = prefNode.get("username", null);
                    password = prefNode.get("password", null);
                    if (username != null && password != null) break block18;
                    return null;
                }
                catch (StorageException storageException) {
                    String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1, msg, null));
                }
            }
            return ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password);
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker adminUITracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        adminUITracker.open();
        IServiceUI adminUIService = (IServiceUI)adminUITracker.getService();
        IServiceUI.AuthenticationInfo loginDetails = null;
        if (adminUIService != null) {
            loginDetails = adminUIService.getUsernamePassword(hostLocation.toString());
        }
        if (loginDetails == null) {
            throw new UserCancelledException();
        }
        if (loginDetails.saveResult()) {
            if (prefNode == null) {
                prefNode = securePreferences.node(nodeName);
            }
            try {
                prefNode.put("username", loginDetails.getUserName(), true);
                prefNode.put("password", loginDetails.getPassword(), true);
                prefNode.flush();
            }
            catch (StorageException storageException) {
                String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1, msg, null));
            }
            catch (IOException iOException) {
                String msg = NLS.bind((String)Messages.repoMan_internalError, (Object)xmlLocation.toString());
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1, msg, null));
            }
        }
        return ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
    }

    private IRemoteFile checkFile(IRemoteFileSystemBrowserContainerAdapter retrievalContainer, String location, IConnectContext context) throws ProtocolException {
        IOException ioException;
        String message;
        final Object[] result = new Object[2];
        final Object FAIL = new Object();
        IRemoteFileSystemListener listener = new IRemoteFileSystemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
                Exception exception = event.getException();
                if (exception != null) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = FAIL;
                        result[1] = exception;
                        result.notify();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
                if (!(event instanceof IRemoteFileSystemBrowseEvent)) return;
                IRemoteFileSystemBrowseEvent fsbe = (IRemoteFileSystemBrowseEvent)event;
                IRemoteFile[] remoteFiles = fsbe.getRemoteFiles();
                if (remoteFiles != null && remoteFiles.length > 0 && remoteFiles[0] != null) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = remoteFiles[0];
                        result.notify();
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return;
                    }
                }
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = FAIL;
                    result.notify();
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return;
                }
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            retrievalContainer.sendBrowseRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getBrowseNamespace(), location), listener);
        }
        catch (RemoteFileSystemException remoteFileSystemException) {
            return null;
        }
        catch (FileCreateException fileCreateException) {
            return null;
        }
        this.waitFor(location, result);
        if (result[0] == FAIL && result[1] instanceof IOException && (message = (ioException = (IOException)result[1]).getMessage()) != null && (message.indexOf(" 401 ") != -1 || message.indexOf(SERVER_REDIRECT) != -1)) {
            throw ERROR_401;
        }
        if (result[0] instanceof IRemoteFile) {
            return (IRemoteFile)result[0];
        }
        return null;
    }

    private void waitFor(String location, Object[] barrier) {
        WaitJob wait = new WaitJob(location, barrier);
        wait.schedule();
        while (barrier[0] == null) {
            boolean logged = false;
            try {
                wait.join();
            }
            catch (InterruptedException e) {
                if (logged) continue;
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.metadata.repository", "Unexpected interrupt while waiting on ECF transfer", (Throwable)e));
            }
        }
    }

    private IStatus transfer(IRetrieveFileTransferContainerAdapter retrievalContainer, String toDownload, final OutputStream target, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        Object[] result = new IStatus[1];
        IFileTransferListener listener = new IFileTransferListener((IStatus[])result, monitor){
            private final /* synthetic */ IStatus[] val$result;
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$result = iStatusArray;
                this.val$monitor = iProgressMonitor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleTransferEvent(IFileTransferEvent event) {
                if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                    IIncomingFileTransferReceiveStartEvent rse = (IIncomingFileTransferReceiveStartEvent)event;
                    if (target != null) {
                        try {
                            rse.receive(target);
                        }
                        catch (IOException e) {
                            IStatus status = ECFMetadataTransport.this.convertToStatus(e);
                            IStatus[] iStatusArray = this.val$result;
                            // MONITORENTER : this.val$result
                            this.val$result[0] = status;
                            this.val$result.notify();
                            // MONITOREXIT : iStatusArray
                        }
                    }
                }
                if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                    IIncomingFileTransfer source = ((IIncomingFileTransferReceiveDataEvent)event).getSource();
                    if (this.val$monitor != null && this.val$monitor.isCanceled()) {
                        source.cancel();
                    }
                }
                if (!(event instanceof IIncomingFileTransferReceiveDoneEvent)) return;
                IStatus status = ECFMetadataTransport.this.convertToStatus(((IIncomingFileTransferReceiveDoneEvent)event).getException());
                IStatus[] iStatusArray = this.val$result;
                // MONITORENTER : this.val$result
                this.val$result[0] = status;
                this.val$result.notify();
                // MONITOREXIT : iStatusArray
                return;
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            retrievalContainer.sendRetrieveRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getRetrieveNamespace(), toDownload), listener, null);
        }
        catch (IncomingFileTransferException e) {
            String message;
            IStatus status = e.getStatus();
            Throwable exception = status.getException();
            if (exception instanceof IOException && (message = exception.getMessage()) != null && (message.indexOf("401") != -1 || message.indexOf(SERVER_REDIRECT) != -1)) {
                throw ERROR_401;
            }
            return status;
        }
        catch (FileCreateException e) {
            return e.getStatus();
        }
        this.waitFor(toDownload, result);
        return result[0];
    }

    protected IStatus convertToStatus(Exception e) {
        if (e == null) {
            return Status.OK_STATUS;
        }
        if (e instanceof UserCancelledException) {
            return new Status(8, "org.eclipse.equinox.p2.metadata.repository", e.getMessage(), (Throwable)e);
        }
        return new Status(4, "org.eclipse.equinox.p2.metadata.repository", e.getMessage(), (Throwable)e);
    }

    static class WaitJob
    extends Job {
        private final Object[] barrier;

        WaitJob(String location, Object[] barrier) {
            super(NLS.bind((String)Messages.repo_loading, (Object)location));
            this.barrier = barrier;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object[] objectArray = this.barrier;
            synchronized (this.barrier) {
                while (true) {
                    if (this.barrier[0] != null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return Status.OK_STATUS;
                    }
                    try {
                        this.barrier.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

