/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitFragment;
import org.eclipse.equinox.internal.p2.metadata.ResolvedInstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.UpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.Copyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.InstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class MetadataFactory {
    private static final TouchpointData EMPTY_TOUCHPOINT_DATA = new TouchpointData(Collections.EMPTY_MAP);
    private static TouchpointType[] typeCache = new TouchpointType[5];
    private static int typeCacheOffset;

    public static IInstallableUnit createInstallableUnit(InstallableUnitDescription description) {
        Assert.isNotNull((Object)description);
        return description.unitCreate();
    }

    public static IInstallableUnitFragment createInstallableUnitFragment(InstallableUnitFragmentDescription description) {
        Assert.isNotNull((Object)description);
        return (IInstallableUnitFragment)description.unitCreate();
    }

    public static IInstallableUnitPatch createInstallableUnitPatch(InstallableUnitPatchDescription description) {
        Assert.isNotNull((Object)description);
        return (IInstallableUnitPatch)description.unitCreate();
    }

    public static ProvidedCapability createProvidedCapability(String namespace, String name, Version version) {
        return new ProvidedCapability(namespace, name, version);
    }

    public static RequiredCapability createRequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple) {
        return new RequiredCapability(namespace, name, range, filter, optional, multiple);
    }

    public static RequiredCapability createRequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        return new RequiredCapability(namespace, name, range, filter, optional, multiple, greedy);
    }

    public static IInstallableUnit createResolvedInstallableUnit(IInstallableUnit unit, IInstallableUnitFragment[] fragments) {
        if (unit.isResolved()) {
            return unit;
        }
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)fragments);
        return new ResolvedInstallableUnit(unit, fragments);
    }

    public static TouchpointData createTouchpointData(Map instructions) {
        Assert.isNotNull((Object)instructions);
        return instructions.isEmpty() ? EMPTY_TOUCHPOINT_DATA : new TouchpointData(new LinkedHashMap(instructions));
    }

    public static TouchpointType createTouchpointType(String id, Version version) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        TouchpointType result = MetadataFactory.getCachedTouchpointType(id, version);
        if (result != null) {
            return result;
        }
        result = new TouchpointType(id, version);
        MetadataFactory.putCachedTouchpointType(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TouchpointType getCachedTouchpointType(String id, Version version) {
        TouchpointType[] touchpointTypeArray = typeCache;
        synchronized (typeCache) {
            int i = 0;
            while (i < typeCache.length) {
                if (typeCache[i] != null && typeCache[i].getId().equals(id) && typeCache[i].getVersion().equals((Object)version)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return typeCache[i];
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private static void putCachedTouchpointType(TouchpointType result) {
        MetadataFactory.typeCache[MetadataFactory.typeCacheOffset] = result;
        typeCacheOffset = (typeCacheOffset + 1) % typeCache.length;
    }

    public static IUpdateDescriptor createUpdateDescriptor(String id, VersionRange range, int severity, String description) {
        return new UpdateDescriptor(id, range, severity, description);
    }

    public static License createLicense(String url, String licenseBody) {
        return new License(url, licenseBody);
    }

    public static Copyright createCopyright(String url, String copyrightBody) {
        return new Copyright(url, copyrightBody);
    }

    public static class InstallableUnitDescription {
        protected InstallableUnit unit;

        public void addTouchpointData(TouchpointData data) {
            Assert.isNotNull((Object)data);
            this.unit().addTouchpointData(data);
        }

        public void setApplicabilityFilter(String ldapFilter) {
            this.unit().setApplicabilityFilter(ldapFilter);
        }

        public void setArtifacts(IArtifactKey[] value) {
            this.unit().setArtifacts(value);
        }

        public void setCapabilities(ProvidedCapability[] exportedCapabilities) {
            this.unit().setCapabilities(exportedCapabilities);
        }

        public void setFilter(String filter) {
            this.unit().setFilter(filter);
        }

        public void setId(String id) {
            this.unit().setId(id);
        }

        public void setLicense(License license) {
            this.unit().setLicense(license);
        }

        public void setCopyright(Copyright copyright) {
            this.unit().setCopyright(copyright);
        }

        public void setProperty(String key, String value) {
            this.unit().setProperty(key, value);
        }

        public void setRequiredCapabilities(RequiredCapability[] capabilities) {
            this.unit().setRequiredCapabilities(capabilities);
        }

        public void setSingleton(boolean singleton) {
            this.unit().setSingleton(singleton);
        }

        public void setTouchpointType(TouchpointType type) {
            this.unit().setTouchpointType(type);
        }

        public void setVersion(Version newVersion) {
            this.unit().setVersion(newVersion);
        }

        public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
            this.unit().setUpdateDescriptor(updateInfo);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnit();
            }
            return this.unit;
        }

        IInstallableUnit unitCreate() {
            InstallableUnit result = this.unit();
            this.unit = null;
            return result;
        }
    }

    public static class InstallableUnitFragmentDescription
    extends InstallableUnitDescription {
        public void setHost(RequiredCapability[] hostRequirements) {
            ((InstallableUnitFragment)this.unit()).setHost(hostRequirements);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnitFragment();
            }
            return this.unit;
        }
    }

    public static class InstallableUnitPatchDescription
    extends InstallableUnitDescription {
        public void setRequirementChanges(RequirementChange[] changes) {
            ((InstallableUnitPatch)this.unit()).setRequirementsChange(changes);
        }

        InstallableUnit unit() {
            if (this.unit == null) {
                this.unit = new InstallableUnitPatch();
            }
            return this.unit;
        }

        public void setApplicabilityScope(RequiredCapability[][] applyTo) {
            ((InstallableUnitPatch)this.unit()).setApplicabilityScope(applyTo);
        }

        public void setLifeCycle(RequiredCapability lifeCycle) {
            ((InstallableUnitPatch)this.unit()).setLifeCycle(lifeCycle);
        }
    }
}

