/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.compare.MultipleSelectionNode;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;

public final class RevisionAwareDifferencer
extends Differencer {
    private static final int NODE_EQUAL = 0;
    private static final int NODE_NOT_EQUAL = 1;
    private static final int NODE_UNKNOWN = 2;
    private File[] diffFiles;
    private List changedResources;
    private SVNDiffSummary[] diffSummary;
    private String projectRelativePath;

    public RevisionAwareDifferencer() {
    }

    public RevisionAwareDifferencer(File[] diffFiles) {
        this.diffFiles = diffFiles;
    }

    public RevisionAwareDifferencer(SVNLocalResourceNode left, ResourceEditionNode right, File diffFile) {
        if (diffFile == null) {
            try {
                this.diffSummary = null;
                ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                this.diffSummary = client.diffSummarize(left.getLocalResource().getUrl(), left.getLocalResource().getRevision(), right.getRemoteResource().getUrl(), right.getRemoteResource().getRevision(), 3, true);
                this.projectRelativePath = left.getLocalResource().getResource().getProjectRelativePath().toString();
                if (left.getLocalResource().isFolder() && this.projectRelativePath.length() > 0) {
                    this.projectRelativePath = String.valueOf(this.projectRelativePath) + "/";
                }
            }
            catch (Exception exception) {}
        } else {
            this.diffFiles = new File[1];
            this.diffFiles[0] = diffFile;
        }
    }

    protected boolean contentsEqual(Object input1, Object input2) {
        if (input1 instanceof MultipleSelectionNode) {
            return true;
        }
        int compare = input1 instanceof SVNLocalResourceNode ? this.compareStatusAndRevisions(input1, input2) : this.compareEditions(input1, input2);
        if (compare == 0) {
            return true;
        }
        if (compare == 1) {
            return false;
        }
        return super.contentsEqual(input1, input2);
    }

    protected void updateProgress(IProgressMonitor progressMonitor, Object node) {
        if (node instanceof ITypedElement) {
            ITypedElement element = (ITypedElement)node;
            progressMonitor.subTask(Policy.bind("CompareEditorInput.fileProgress", new String[]{element.getName()}));
            progressMonitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int compareStatusAndRevisions(Object left, Object right) {
        String rightLocation;
        ISVNLocalResource localResource = null;
        if (left instanceof SVNLocalResourceNode) {
            localResource = ((SVNLocalResourceNode)((Object)left)).getLocalResource();
        }
        ISVNRemoteResource edition = null;
        if (right instanceof ResourceEditionNode) {
            edition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (localResource == null) return 2;
        if (edition == null) {
            return 2;
        }
        if (localResource.isFolder() && edition.isContainer()) {
            return 0;
        }
        if (localResource.isFolder() != edition.isContainer()) {
            return 1;
        }
        String leftLocation = localResource.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = edition.getRepository().getLocation())) {
            return 2;
        }
        LocalResourceStatus localStatus = null;
        try {
            localStatus = localResource.getStatus();
            if (localStatus == null) {
                return 2;
            }
            if (!localResource.isDirty() && localResource.getResource().getProjectRelativePath().toString().equals(edition.getProjectRelativePath()) && localStatus.getLastChangedRevision().equals((Object)edition.getLastChangedRevision())) {
                return 0;
            }
            if (localResource.isDirty()) return 2;
            if (localResource.isFolder()) return 2;
            if (this.changedResources == null && this.diffFiles != null) {
                this.parseDiffs();
            }
            if (this.changedResources != null) {
                if (!this.changedResources.contains(localResource.getResource().getLocation().toString())) return 0;
                return 1;
            }
            int i = 0;
            while (true) {
                if (i >= this.diffSummary.length) {
                    return 0;
                }
                if (localResource.getResource().getProjectRelativePath().toString().equals(this.projectRelativePath)) return 1;
                if (localResource.getResource().getProjectRelativePath().toString().equals(String.valueOf(this.projectRelativePath) + this.diffSummary[i].getPath())) {
                    return 1;
                }
                ++i;
            }
        }
        catch (SVNException sVNException) {
            return 2;
        }
    }

    protected int compareEditions(Object left, Object right) {
        String rightLocation;
        ISVNRemoteResource leftEdition = null;
        if (left instanceof ResourceEditionNode) {
            leftEdition = ((ResourceEditionNode)left).getRemoteResource();
        }
        ISVNRemoteResource rightEdition = null;
        if (right instanceof ResourceEditionNode) {
            rightEdition = ((ResourceEditionNode)right).getRemoteResource();
        }
        if (leftEdition == null || rightEdition == null) {
            return 2;
        }
        if (leftEdition.isContainer() && rightEdition.isContainer()) {
            return 0;
        }
        if (leftEdition.isContainer() != rightEdition.isContainer()) {
            return 1;
        }
        String leftLocation = leftEdition.getRepository().getLocation();
        if (!leftLocation.equals(rightLocation = rightEdition.getRepository().getLocation())) {
            return 2;
        }
        if (leftEdition.getUrl().equals((Object)rightEdition.getUrl()) && leftEdition.getLastChangedRevision().equals((Object)rightEdition.getLastChangedRevision())) {
            return 0;
        }
        return 2;
    }

    private void parseDiffs() {
        this.changedResources = new ArrayList();
        int i = 0;
        while (i < this.diffFiles.length) {
            this.parseFile(this.diffFiles[i]);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void parseFile(File diffFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

