/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class UrlCombo
extends Composite {
    private Combo combo;
    private IDialogSettings settings;
    private String projectName;
    private static final int URL_WIDTH_HINT = 450;

    public UrlCombo(Composite parent, int style) {
        super(parent, style);
        this.createCombo();
    }

    private void createCombo() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.combo = new Combo((Composite)this, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 450;
        this.combo.setLayoutData((Object)gridData);
    }

    public Combo getCombo() {
        return this.combo;
    }

    public String getText() {
        return this.combo.getText().trim();
    }

    public void setText(String text) {
        this.combo.setText(text);
    }

    public void init(String projectName) {
        this.projectName = projectName;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        int i = 0;
        while (i < 5) {
            String url = this.settings.get("UrlCombo." + projectName + "." + i);
            if (url == null) break;
            this.combo.add(url);
            ++i;
        }
    }

    public void saveUrl() {
        if (this.projectName == null || this.settings == null) {
            return;
        }
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.getText());
        int i = 0;
        while (i < 5) {
            String url = this.settings.get("UrlCombo." + this.projectName + "." + i);
            if (url == null) break;
            if (!urls.contains(url)) {
                urls.add(url);
            }
            ++i;
        }
        i = 0;
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            String url = (String)iter.next();
            this.settings.put("UrlCombo." + this.projectName + "." + i++, url);
            if (i == 5) break;
        }
    }
}

