/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.IntPair;
import java.io.PrintStream;
import java.util.HashMap;

public class Feature {
    public int[] indexedValues;
    public double[] valuesI;
    static Experiments domain;
    protected HashMap hashValues;
    public double sum;
    public Index instanceIndex;

    public Feature() {
    }

    public Feature(Experiments e, double[] vals, Index instanceIndex) {
        this.instanceIndex = instanceIndex;
        HashMap<Integer, Double> setNonZeros = new HashMap<Integer, Double>();
        int i = 0;
        while (i < vals.length) {
            if (vals[i] != 0.0) {
                Integer in = new Integer(this.indexOf(e.get(i)[0], e.get(i)[1]));
                Object val = setNonZeros.get(in);
                if (val == null) {
                    setNonZeros.put(in, new Double(vals[i]));
                } else if ((Double)val != vals[i]) {
                    System.out.println(" Incorrect function specification");
                    System.out.println(" Has two values for one point ");
                    System.exit(1);
                }
            }
            ++i;
        }
        Object[] keys = setNonZeros.keySet().toArray();
        this.indexedValues = new int[keys.length];
        this.valuesI = new double[keys.length];
        int j = 0;
        while (j < keys.length) {
            this.indexedValues[j] = (Integer)keys[j];
            this.valuesI[j] = (Double)setNonZeros.get(keys[j]);
            ++j;
        }
        domain = e;
    }

    int indexOf(int x, int y) {
        IntPair iP = new IntPair(x, y);
        return this.instanceIndex.indexOf(iP);
    }

    IntPair getPair(int index) {
        return (IntPair)this.instanceIndex.get(index);
    }

    int getXInstance(int index) {
        IntPair iP = this.getPair(index);
        return iP.get(0);
    }

    int getYInstance(int index) {
        IntPair iP = this.getPair(index);
        return iP.get(1);
    }

    public Feature(Experiments e, double[][] vals, Index instanceIndex) {
        this.instanceIndex = instanceIndex;
        domain = e;
        int num = 0;
        int x = 0;
        while (x < Experiments.xSize) {
            int y = 0;
            while (y < Experiments.ySize) {
                if (vals[x][y] != 0.0) {
                    ++num;
                }
                ++y;
            }
            ++x;
        }
        this.indexedValues = new int[num];
        this.valuesI = new double[num];
        int current = 0;
        int x2 = 0;
        while (x2 < Experiments.xSize) {
            int y = 0;
            while (y < Experiments.ySize) {
                if (vals[x2][y] != 0.0) {
                    this.indexedValues[current] = this.indexOf(x2, y);
                    this.valuesI[current] = vals[x2][y];
                    ++current;
                }
                ++y;
            }
            ++x2;
        }
    }

    public Feature(Experiments e, int numElems, Index instanceIndex) {
        this.instanceIndex = instanceIndex;
        domain = e;
        this.indexedValues = new int[numElems];
        this.valuesI = new double[numElems];
    }

    public Feature(Experiments e, int[] indexes, double[] vals, Index instanceIndex) {
        domain = e;
        this.indexedValues = indexes;
        this.valuesI = vals;
        this.instanceIndex = instanceIndex;
    }

    public void print() {
        this.print(System.out);
    }

    public void setValue(int index, int key, double value) {
        this.indexedValues[index] = key;
        this.valuesI[index] = value;
    }

    public void print(PrintStream pf) {
        int i = 0;
        while (i < this.indexedValues.length) {
            IntPair iP = this.getPair(this.indexedValues[i]);
            int x = iP.get(0);
            int y = iP.get(1);
            pf.println(String.valueOf(x) + ", " + y + " " + this.valuesI[i]);
            ++i;
        }
    }

    public double getVal(int index) {
        return this.valuesI[index];
    }

    public void setSum() {
        int i = 0;
        while (i < this.valuesI.length) {
            this.sum += this.valuesI[i];
            ++i;
        }
    }

    public double sumValues() {
        return this.sum;
    }

    public void save(OutDataStreamFile oF) {
        throw new UnsupportedOperationException();
    }

    public void read(InDataStreamFile inf) {
        throw new UnsupportedOperationException();
    }

    public int len() {
        if (this.indexedValues != null) {
            return this.indexedValues.length;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.len() == 0;
    }

    public int getX(int index) {
        return this.getXInstance(this.indexedValues[index]);
    }

    public int getY(int index) {
        return this.getYInstance(this.indexedValues[index]);
    }

    public double getVal(int x, int y) {
        Double val = (Double)this.hashValues.get(new Integer(this.indexOf(x, y)));
        if (val == null) {
            return 0.0;
        }
        return val;
    }

    public void initHashVals() {
        this.hashValues = new HashMap();
        int i = 0;
        while (i < this.len()) {
            int x = this.getX(i);
            int y = this.getY(i);
            Double value = new Double(this.getVal(i));
            this.hashValues.put(new Integer(this.indexOf(x, y)), value);
            ++i;
        }
    }

    public double ftilde() {
        double s = 0.0;
        int i = 0;
        while (i < this.indexedValues.length) {
            int x = this.getXInstance(this.indexedValues[i]);
            int y = this.getYInstance(this.indexedValues[i]);
            s += domain.ptildeXY(x, y) * this.getVal(i);
            ++i;
        }
        return s;
    }
}

