/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGrammar
implements Serializable,
Iterable<BinaryRule> {
    private String stateSpace;
    private int numStates;
    private List<BinaryRule> allRules;
    private transient List<BinaryRule>[] rulesWithParent;
    private transient List<BinaryRule>[] rulesWithLC;
    private transient List<BinaryRule>[] rulesWithRC;
    private transient BinaryRule[][] splitRulesWithLC;
    private transient BinaryRule[][] splitRulesWithRC;
    private transient Map<BinaryRule, BinaryRule> ruleMap;
    private transient boolean[] synthetic;
    private static final long serialVersionUID = 1L;

    public int numRules() {
        return this.allRules.size();
    }

    public List<BinaryRule> rules() {
        return this.allRules;
    }

    public String stateSpace() {
        return this.stateSpace;
    }

    public boolean isSynthetic(int n) {
        return this.synthetic[n];
    }

    private BinaryRule[] toBRArray(List<BinaryRule> list) {
        BinaryRule[] binaryRuleArray = new BinaryRule[list.size()];
        for (int i = 0; i < binaryRuleArray.length; ++i) {
            binaryRuleArray[i] = list.get(i);
        }
        return binaryRuleArray;
    }

    public void splitRules() {
        int n;
        Numberer numberer = Numberer.getGlobalNumberer(this.stateSpace);
        this.synthetic = new boolean[this.numStates];
        for (n = 0; n < this.numStates; ++n) {
            try {
                this.synthetic[n] = ((String)numberer.object(n)).charAt(0) == '@';
                continue;
            }
            catch (NullPointerException nullPointerException) {
                this.synthetic[n] = true;
            }
        }
        this.splitRulesWithLC = new BinaryRule[this.numStates][];
        this.splitRulesWithRC = new BinaryRule[this.numStates][];
        for (n = 0; n < this.numStates; ++n) {
            if (this.isSynthetic(n)) {
                this.splitRulesWithLC[n] = this.toBRArray(this.rulesWithLC[n]);
                this.splitRulesWithRC[n] = this.toBRArray(this.rulesWithRC[n]);
                continue;
            }
            ArrayList<BinaryRule> arrayList = new ArrayList<BinaryRule>();
            for (BinaryRule binaryRule : this.rulesWithLC[n]) {
                if (this.isSynthetic(binaryRule.rightChild)) continue;
                arrayList.add(binaryRule);
            }
            this.splitRulesWithLC[n] = this.toBRArray(arrayList);
            arrayList.clear();
            for (BinaryRule binaryRule : this.rulesWithRC[n]) {
                if (this.isSynthetic(binaryRule.leftChild)) continue;
                arrayList.add(binaryRule);
            }
            this.splitRulesWithRC[n] = this.toBRArray(arrayList);
        }
    }

    public BinaryRule[] splitRulesWithLC(int n) {
        if (n >= this.splitRulesWithLC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithLC[n];
    }

    public BinaryRule[] splitRulesWithRC(int n) {
        if (n >= this.splitRulesWithRC.length) {
            return new BinaryRule[0];
        }
        return this.splitRulesWithRC[n];
    }

    public double scoreRule(BinaryRule binaryRule) {
        BinaryRule binaryRule2 = this.ruleMap.get(binaryRule);
        return binaryRule2 != null ? (double)binaryRule2.score : Double.NEGATIVE_INFINITY;
    }

    public void addRule(BinaryRule binaryRule) {
        this.rulesWithParent[binaryRule.parent].add(binaryRule);
        this.rulesWithLC[binaryRule.leftChild].add(binaryRule);
        this.rulesWithRC[binaryRule.rightChild].add(binaryRule);
        this.allRules.add(binaryRule);
        this.ruleMap.put(binaryRule, binaryRule);
    }

    @Override
    public Iterator<BinaryRule> iterator() {
        return this.allRules.iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByParent(int n) {
        if (n >= this.rulesWithParent.length) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.rulesWithParent[n].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByRightChild(int n) {
        if (n >= this.rulesWithRC.length) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.rulesWithRC[n].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByLeftChild(int n) {
        if (n >= this.rulesWithLC.length) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.rulesWithLC[n].iterator();
    }

    public List ruleListByParent(int n) {
        if (n >= this.rulesWithParent.length) {
            List list = Collections.emptyList();
            return list;
        }
        return this.rulesWithParent[n];
    }

    public List<BinaryRule> ruleListByRightChild(int n) {
        if (n >= this.rulesWithRC.length) {
            List<BinaryRule> list = Collections.emptyList();
            return list;
        }
        return this.rulesWithRC[n];
    }

    public List<BinaryRule> ruleListByLeftChild(int n) {
        if (n >= this.rulesWithRC.length) {
            List<BinaryRule> list = Collections.emptyList();
            return list;
        }
        return this.rulesWithLC[n];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
        for (BinaryRule binaryRule : this.allRules) {
            this.rulesWithParent[binaryRule.parent].add(binaryRule);
            this.rulesWithLC[binaryRule.leftChild].add(binaryRule);
            this.rulesWithRC[binaryRule.rightChild].add(binaryRule);
            this.ruleMap.put(binaryRule, binaryRule);
        }
    }

    private void init() {
        this.ruleMap = new HashMap<BinaryRule, BinaryRule>();
        this.rulesWithParent = new List[this.numStates];
        this.rulesWithLC = new List[this.numStates];
        this.rulesWithRC = new List[this.numStates];
        for (int i = 0; i < this.numStates; ++i) {
            this.rulesWithParent[i] = new ArrayList<BinaryRule>();
            this.rulesWithLC[i] = new ArrayList<BinaryRule>();
            this.rulesWithRC[i] = new ArrayList<BinaryRule>();
        }
    }

    public BinaryGrammar(int n) {
        this(n, "states");
    }

    public BinaryGrammar(int n, String string) {
        this.stateSpace = string;
        this.numStates = n;
        this.allRules = new ArrayList<BinaryRule>();
        this.init();
    }

    public void readData(BufferedReader bufferedReader) throws IOException {
        int n = 1;
        Numberer numberer = Numberer.getGlobalNumberer("states");
        String string = bufferedReader.readLine();
        while (string != null && string.length() > 0) {
            try {
                this.addRule(new BinaryRule(string, numberer));
            }
            catch (Exception exception) {
                throw new IOException("Error on line " + n);
            }
            ++n;
            string = bufferedReader.readLine();
        }
        this.splitRules();
    }

    public void writeData(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (BinaryRule binaryRule : this) {
            printWriter.println(binaryRule);
        }
        printWriter.flush();
    }
}

