/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class BinaryRule
extends Rule
implements Serializable,
Comparable {
    public int leftChild = -1;
    public int rightChild = -1;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 1L;

    public BinaryRule() {
    }

    public BinaryRule(String string, Numberer numberer) {
        String[] stringArray = StringUtils.splitOnCharWithQuoting(string, ' ', '\"', '\\');
        this.parent = numberer.number(stringArray[0]);
        this.leftChild = numberer.number(stringArray[2]);
        this.rightChild = numberer.number(stringArray[3]);
        this.score = Float.parseFloat(stringArray[4]);
    }

    public BinaryRule(int n, int n2, int n3, double d) {
        this.parent = n;
        this.leftChild = n2;
        this.rightChild = n3;
        this.score = (float)d;
    }

    public int hashCode() {
        return this.parent << 16 ^ this.leftChild << 8 ^ this.rightChild;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BinaryRule) {
            BinaryRule binaryRule = (BinaryRule)object;
            if (this.parent == binaryRule.parent && this.leftChild == binaryRule.leftChild && this.rightChild == binaryRule.rightChild) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Numberer numberer = Numberer.getGlobalNumberer("states");
        return "\"" + StringUtils.escapeString(numberer.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(numberer.object(this.leftChild).toString(), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(numberer.object(this.rightChild).toString(), charsToEscape, '\\') + "\" " + this.score;
    }

    public int compareTo(Object object) {
        BinaryRule binaryRule = (BinaryRule)object;
        if (this.parent < binaryRule.parent) {
            return -1;
        }
        if (this.parent > binaryRule.parent) {
            return 1;
        }
        if (this.leftChild < binaryRule.leftChild) {
            return -1;
        }
        if (this.leftChild > binaryRule.leftChild) {
            return 1;
        }
        if (this.rightChild < binaryRule.rightChild) {
            return -1;
        }
        if (this.rightChild > binaryRule.rightChild) {
            return 1;
        }
        return 0;
    }
}

