/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import java.util.Arrays;

class FA {
    protected boolean[] inStatePrev;
    protected boolean[] inStateNext;
    protected boolean[] loopState;
    protected int acceptingState;
    protected int initialState;
    protected int numStates;
    protected int numSymbols;
    protected int[][] transition;

    public void init() {
        Arrays.fill(this.inStatePrev, false);
        Arrays.fill(this.inStateNext, false);
        this.inStatePrev[this.initialState] = true;
    }

    public void input(int symbol) {
        for (int prevState = 0; prevState < this.numStates; ++prevState) {
            if (!this.inStatePrev[prevState]) continue;
            this.inStateNext[this.transition[prevState][symbol]] = true;
        }
    }

    public void advance() {
        boolean[] temp = this.inStatePrev;
        this.inStatePrev = this.inStateNext;
        this.inStateNext = temp;
        Arrays.fill(this.inStateNext, false);
        for (int state = 0; state < this.numStates; ++state) {
            if (!this.inStatePrev[state] || !this.loopState[state]) continue;
            this.inStateNext[state] = true;
        }
    }

    public boolean isAccepting() {
        return this.inStatePrev[this.acceptingState];
    }

    public void setTransition(int state, int symbol, int result) {
        this.transition[state][symbol] = result;
    }

    public void setLoopState(int state, boolean loops) {
        this.loopState[state] = loops;
    }

    public FA(int numStates, int numSymbols) {
        this.numStates = numStates;
        this.numSymbols = numSymbols;
        this.acceptingState = numStates - 1;
        this.inStatePrev = new boolean[numStates];
        this.inStateNext = new boolean[numStates];
        this.loopState = new boolean[numStates];
        this.transition = new int[numStates][numSymbols];
    }
}

