/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Interner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class HookChart {
    private Map registeredPreHooks = new HashMap();
    private Map registeredPostHooks = new HashMap();
    private Map registeredEdgesByLeftIndex = new HashMap();
    private Map registeredEdgesByRightIndex = new HashMap();
    private Map<WeakChartIndex, Collection> realEdgesByL = new HashMap<WeakChartIndex, Collection>();
    private Map<WeakChartIndex, Collection> realEdgesByR = new HashMap<WeakChartIndex, Collection>();
    private Set<ChartIndex> builtLIndexes = new HashSet<ChartIndex>();
    private Set<ChartIndex> builtRIndexes = new HashSet<ChartIndex>();
    private Interner interner = new Interner();
    private static final Collection empty = new ArrayList(0);
    private WeakChartIndex tempWeakIndex = new WeakChartIndex();
    ChartIndex tempIndex = new ChartIndex();

    HookChart() {
    }

    public void registerEdgeIndexes(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        ChartIndex index = (ChartIndex)this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
        this.builtLIndexes.add(index);
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.end;
        index = (ChartIndex)this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
        this.builtRIndexes.add(index);
    }

    public void registerRealEdge(Edge edge) {
        this.tempWeakIndex.state = edge.state;
        this.tempWeakIndex.loc = edge.start;
        WeakChartIndex index = (WeakChartIndex)this.interner.intern(this.tempWeakIndex);
        if (index == this.tempWeakIndex) {
            this.tempWeakIndex = new WeakChartIndex();
        }
        HookChart.insert(this.realEdgesByL, index, edge);
        this.tempWeakIndex.state = edge.state;
        this.tempWeakIndex.loc = edge.end;
        index = (WeakChartIndex)this.interner.intern(this.tempWeakIndex);
        if (index == this.tempWeakIndex) {
            this.tempWeakIndex = new WeakChartIndex();
        }
        HookChart.insert(this.realEdgesByR, index, edge);
    }

    public boolean isBuiltL(int state, int start, int head, int tag) {
        this.tempIndex.state = state;
        this.tempIndex.head = head;
        this.tempIndex.tag = tag;
        this.tempIndex.loc = start;
        return this.builtLIndexes.contains(this.tempIndex);
    }

    public boolean isBuiltR(int state, int end, int head, int tag) {
        this.tempIndex.state = state;
        this.tempIndex.head = head;
        this.tempIndex.tag = tag;
        this.tempIndex.loc = end;
        return this.builtRIndexes.contains(this.tempIndex);
    }

    public Collection getRealEdgesWithL(int state, int start) {
        this.tempWeakIndex.state = state;
        this.tempWeakIndex.loc = start;
        Collection edges = this.realEdgesByL.get(this.tempWeakIndex);
        if (edges == null) {
            return empty;
        }
        return edges;
    }

    public Collection getRealEdgesWithR(int state, int end) {
        this.tempWeakIndex.state = state;
        this.tempWeakIndex.loc = end;
        Collection edges = this.realEdgesByR.get(this.tempWeakIndex);
        if (edges == null) {
            return empty;
        }
        return edges;
    }

    public Collection getPreHooks(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.end;
        Collection result = (Collection)this.registeredPreHooks.get(this.tempIndex);
        if (result == null) {
            result = empty;
        }
        return result;
    }

    public Collection getPostHooks(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        Collection result = (Collection)this.registeredPostHooks.get(this.tempIndex);
        if (result == null) {
            result = empty;
        }
        return result;
    }

    public Collection getEdges(Hook hook) {
        Collection result;
        this.tempIndex.state = hook.subState;
        this.tempIndex.head = hook.head;
        this.tempIndex.tag = hook.tag;
        if (hook.isPreHook()) {
            this.tempIndex.loc = hook.start;
            result = (Collection)this.registeredEdgesByRightIndex.get(this.tempIndex);
        } else {
            this.tempIndex.loc = hook.end;
            result = (Collection)this.registeredEdgesByLeftIndex.get(this.tempIndex);
        }
        if (result == null) {
            result = empty;
        }
        return result;
    }

    private static void insert(Map map, Object index, Object item) {
        ArrayList<Object> list = (ArrayList<Object>)map.get(index);
        if (list == null) {
            list = new ArrayList<Object>();
            map.put(index, list);
        }
        list.add(item);
    }

    public void addEdge(Edge edge) {
        this.tempIndex.state = edge.state;
        this.tempIndex.head = edge.head;
        this.tempIndex.tag = edge.tag;
        this.tempIndex.loc = edge.start;
        ChartIndex index = (ChartIndex)this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
            this.tempIndex.state = edge.state;
            this.tempIndex.head = edge.head;
            this.tempIndex.tag = edge.tag;
        }
        HookChart.insert(this.registeredEdgesByLeftIndex, index, edge);
        this.tempIndex.loc = edge.end;
        index = (ChartIndex)this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
        HookChart.insert(this.registeredEdgesByRightIndex, index, edge);
    }

    public void addHook(Hook hook) {
        Map map;
        this.tempIndex.state = hook.subState;
        this.tempIndex.head = hook.head;
        this.tempIndex.tag = hook.tag;
        if (hook.isPreHook()) {
            this.tempIndex.loc = hook.start;
            map = this.registeredPreHooks;
        } else {
            this.tempIndex.loc = hook.end;
            map = this.registeredPostHooks;
        }
        ChartIndex index = (ChartIndex)this.interner.intern(this.tempIndex);
        if (index == this.tempIndex) {
            this.tempIndex = new ChartIndex();
        }
        HookChart.insert(map, index, hook);
    }

    private static class WeakChartIndex {
        public int state;
        public int loc;

        private WeakChartIndex() {
        }

        public int hashCode() {
            return this.state ^ this.loc << 16;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WeakChartIndex) {
                WeakChartIndex ci = (WeakChartIndex)o;
                return this.state == ci.state && this.loc == ci.loc;
            }
            return false;
        }
    }

    private static class ChartIndex {
        public int state;
        public int head;
        public int tag;
        public int loc;

        private ChartIndex() {
        }

        public int hashCode() {
            return this.state ^ this.head << 8 ^ this.tag << 16 ^ this.loc << 24;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ChartIndex) {
                ChartIndex ci = (ChartIndex)o;
                return this.state == ci.state && this.head == ci.head && this.tag == ci.tag && this.loc == ci.loc;
            }
            return false;
        }
    }
}

