/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.fsm.ExactGrammarCompactor;
import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.parser.ViterbiParser;
import edu.stanford.nlp.parser.lexparser.AbstractEval;
import edu.stanford.nlp.parser.lexparser.BiLexPCFGParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.CollinsPuncTransformer;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.EvalB;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.FactoredParser;
import edu.stanford.nlp.parser.lexparser.GrammarCompactor;
import edu.stanford.nlp.parser.lexparser.IterativeCKYPCFGParser;
import edu.stanford.nlp.parser.lexparser.LabeledConstituentEval;
import edu.stanford.nlp.parser.lexparser.LatticeReader;
import edu.stanford.nlp.parser.lexparser.LeftHeadFinder;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammarExtractor;
import edu.stanford.nlp.parser.lexparser.NodePruner;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.ParserData;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreeAnnotator;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.lexparser.TwinScorer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.CompositeTreeTransformer;
import edu.stanford.nlp.trees.CompositeTreebank;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalizedParser
implements ViterbiParser,
Function<Object, Tree> {
    static boolean basicCategoryTagsInDependencyGrammar = false;
    private boolean fallbackToPCFG = false;
    protected ExhaustivePCFGParser pparser;
    protected ExhaustiveDependencyParser dparser;
    protected BiLexPCFGParser bparser;
    protected TreeTransformer debinarizer;
    private TreeTransformer subcategoryStripper;
    private transient ParserData pd;
    private Options op;
    private static final String SERIALIZED_PARSER_PROPERTY = "edu.stanford.nlp.SerializedLexicalizedParser";
    private static final String DEFAULT_PARSER_LOC = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    private static boolean parseSucceeded = false;
    static int trainLengthLimit = 100000;

    public Options getOp() {
        return this.op;
    }

    @Override
    public Tree apply(Object in) {
        List<Word> lst;
        if (in instanceof String) {
            DocumentPreprocessor dp = new DocumentPreprocessor(this.op.tlpParams.treebankLanguagePack().getTokenizerFactory());
            lst = dp.getWordsFromString((String)in);
        } else if (in instanceof List) {
            lst = (List<Word>)in;
        } else {
            throw new IllegalArgumentException("Can only parse Sentence/List/String");
        }
        try {
            if (this.parse(lst)) {
                return this.getBestParse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LabeledScoredTreeFactory lstf = new LabeledScoredTreeFactory();
        ArrayList<Tree> lst2 = new ArrayList<Tree>();
        for (Word obj : lst) {
            String s = ((Object)obj).toString();
            Tree t = lstf.newLeaf(s);
            Tree t2 = lstf.newTreeNode("X", Collections.singletonList(t));
            lst2.add(t2);
        }
        return lstf.newTreeNode("X", lst2);
    }

    @Override
    public boolean parse(Sentence sentence) {
        return this.parse((List)sentence);
    }

    @Override
    public boolean parse(Sentence sentence, String goal) {
        return this.parse((List)sentence);
    }

    public TreePrint getTreePrint() {
        return Test.treePrint(this.op.tlpParams);
    }

    public boolean parse(String sentence) {
        DocumentPreprocessor dp = new DocumentPreprocessor(this.op.tlpParams.treebankLanguagePack().getTokenizerFactory());
        return this.parse(dp.getWordsFromString(sentence));
    }

    public boolean parse(List sentence) {
        int length = sentence.size();
        if (length == 0) {
            throw new UnsupportedOperationException("Can't parse a zero-length sentence!");
        }
        ArrayList<String> sentenceB = new ArrayList<String>(sentence);
        if (Test.addMissingFinalPunctuation) {
            this.addSentenceFinalPunctIfNeeded(sentenceB, length);
        }
        if (length > Test.maxLength) {
            throw new UnsupportedOperationException("Sentence too long: length " + length);
        }
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        parseSucceeded = false;
        sentenceB.add(".$.");
        if (this.op.doPCFG) {
            if (!this.pparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("PParser output");
                treePrint.printTree(this.debinarizer.transformTree(this.pparser.getBestParse()), pwOut);
            }
        }
        if (this.op.doDep) {
            if (!this.dparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("DParser output");
                treePrint.printTree(this.dparser.getBestParse(), pwOut);
            }
        }
        if (this.op.doPCFG && this.op.doDep) {
            if (!this.bparser.parse(sentenceB)) {
                return parseSucceeded;
            }
            parseSucceeded = true;
        }
        return true;
    }

    public boolean parse(LatticeReader lr) {
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        parseSucceeded = false;
        if (lr.getNumStates() > Test.maxLength + 1) {
            throw new UnsupportedOperationException("Lattice too big: " + lr.getNumStates());
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(lr)) {
                return parseSucceeded;
            }
            if (Test.verbose) {
                System.out.println("PParser output");
                treePrint.printTree(this.debinarizer.transformTree(this.pparser.getBestParse()), pwOut);
            }
        }
        return true;
    }

    public void addSentenceFinalPunctIfNeeded(List sentence, int length) {
        int start = length - 3;
        if (start < 0) {
            start = 0;
        }
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        int i = length - 1;
        while (i >= start) {
            String str;
            String tag;
            Object item = sentence.get(i);
            if (item instanceof HasTag ? tlp.isSentenceFinalPunctuationTag(tag = ((HasTag)item).tag()) : (item instanceof HasWord ? tlp.isPunctuationWord(str = ((HasWord)item).word()) : tlp.isPunctuationWord(str = item.toString()))) {
                return;
            }
            --i;
        }
        String[] sfpWords = tlp.sentenceFinalPunctuationWords();
        if (sfpWords.length > 0) {
            sentence.add(sfpWords[0]);
        }
    }

    @Override
    public Tree getBestParse() {
        if (this.bparser != null && parseSucceeded) {
            Tree binaryTree = this.bparser.getBestParse();
            Tree tree = this.debinarizer.transformTree(binaryTree);
            if (this.op.nodePrune) {
                NodePruner np = new NodePruner(this.pparser, this.debinarizer);
                tree = np.prune(tree);
            }
            return this.subcategoryStripper.transformTree(tree);
        }
        if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
            return this.getBestPCFGParse();
        }
        if (this.dparser != null && this.dparser.hasParse()) {
            return this.getBestDependencyParse(true);
        }
        throw new NoSuchElementException();
    }

    public Tree getBestPCFGParse() {
        return this.getBestPCFGParse(true);
    }

    public Tree getBestPCFGParse(boolean stripSubcategories) {
        if (this.pparser == null) {
            return null;
        }
        Tree binaryTree = this.pparser.getBestParse();
        if (binaryTree == null) {
            return null;
        }
        Tree t = this.debinarizer.transformTree(binaryTree);
        if (stripSubcategories) {
            t = this.subcategoryStripper.transformTree(t);
        }
        return t;
    }

    public double getPCFGScore() {
        return this.getPCFGScore(this.pparser.goalStr);
    }

    public double getPCFGScore(String goalStr) {
        if (!this.pparser.stateNumberer.hasSeen(goalStr)) {
            return Double.NEGATIVE_INFINITY;
        }
        this.pparser.setGoalString(goalStr);
        return this.pparser.getLogScore();
    }

    public Tree getBestDependencyParse() {
        return this.getBestDependencyParse(false);
    }

    public Tree getBestDependencyParse(boolean debinarize) {
        Tree t;
        Tree tree = t = this.dparser != null ? this.dparser.getBestParse() : null;
        if (debinarize && t != null) {
            t = this.debinarizer.transformTree(t);
        }
        return t;
    }

    public LexicalizedParser() {
        this(new Options());
    }

    public LexicalizedParser(Options op) {
        this.op = op;
        String source = System.getProperty(SERIALIZED_PARSER_PROPERTY);
        if (source == null) {
            source = DEFAULT_PARSER_LOC;
        }
        this.pd = LexicalizedParser.getParserDataFromFile(source, op);
        this.op = this.pd.pt;
        this.makeParsers();
    }

    public LexicalizedParser(String parserFileOrUrl, Options op) {
        this.op = op;
        this.pd = LexicalizedParser.getParserDataFromFile(parserFileOrUrl, op);
        this.op = this.pd.pt;
        this.makeParsers();
    }

    public LexicalizedParser(String parserFileOrUrl) {
        this(parserFileOrUrl, new Options());
    }

    public void setMaxLength(int maxLength) {
        Test.maxLength = maxLength;
    }

    public static ParserData getParserDataFromFile(String parserFileOrUrl, Options op) {
        ParserData pd = LexicalizedParser.getParserDataFromSerializedFile(parserFileOrUrl);
        if (pd == null) {
            pd = LexicalizedParser.getParserDataFromTextFile(parserFileOrUrl, op);
        }
        return pd;
    }

    public LexicalizedParser(String parserFileOrUrl, boolean isTextGrammar, Options op) {
        this.op = op;
        if (isTextGrammar) {
            this.pd = LexicalizedParser.getParserDataFromTextFile(parserFileOrUrl, op);
        } else {
            this.pd = LexicalizedParser.getParserDataFromSerializedFile(parserFileOrUrl);
            this.op = this.pd.pt;
        }
        this.makeParsers();
    }

    public LexicalizedParser(ParserData pd) {
        this.pd = pd;
        this.makeParsers();
    }

    public LexicalizedParser(ObjectInputStream in) throws Exception {
        this((ParserData)in.readObject());
    }

    public LexicalizedParser(Treebank trainTreebank, GrammarCompactor compactor, Options op) {
        this(trainTreebank, compactor, op, null);
    }

    public LexicalizedParser(String treebankPath, FileFilter filt, Options op) {
        this(LexicalizedParser.makeTreebank(treebankPath, op, filt), op);
    }

    private static Treebank makeTreebank(String treebankPath, Options op, FileFilter filt) {
        System.err.println("Training a parser from treebank dir: " + treebankPath);
        MemoryTreebank trainTreebank = op.tlpParams.memoryTreebank();
        System.err.print("Reading trees...");
        if (filt == null) {
            trainTreebank.loadPath(treebankPath);
        } else {
            trainTreebank.loadPath(treebankPath, filt);
        }
        Timing.tick("done [read " + ((Treebank)trainTreebank).size() + " trees].");
        return trainTreebank;
    }

    private static DiskTreebank makeSecondaryTreebank(String treebankPath, Options op, FileFilter filt) {
        System.err.println("Additionally using secondary disk treebank: " + treebankPath);
        DiskTreebank trainTreebank = op.tlpParams.diskTreebank();
        if (filt == null) {
            trainTreebank.loadPath(treebankPath);
        } else {
            trainTreebank.loadPath(treebankPath, filt);
        }
        return trainTreebank;
    }

    public LexicalizedParser(Treebank trainTreebank, GrammarCompactor compactor, Options op, Treebank tuneTreebank) {
        this.op = op;
        this.pd = this.getParserDataFromTreebank(trainTreebank, compactor, tuneTreebank);
        this.makeParsers();
    }

    public LexicalizedParser(Treebank trainTreebank, DiskTreebank secondaryTrainTreebank, double weight, GrammarCompactor compactor, Options op) {
        this.op = op;
        this.pd = this.getParserDataFromTreebank(trainTreebank, secondaryTrainTreebank, weight, compactor);
        this.makeParsers();
    }

    public LexicalizedParser(Treebank trainTreebank, Options op) {
        this(trainTreebank, null, op);
    }

    public ParserData parserData() {
        return this.pd;
    }

    public Lexicon getLexicon() {
        return this.pd.lex;
    }

    static void saveParserDataToSerialized(ParserData pd, String filename) {
        try {
            System.err.print("Writing parser in serialized format to file " + filename + " ");
            ObjectOutputStream out2 = filename.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            out2.writeObject(pd);
            out2.close();
            System.err.println("done.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void saveParserDataToText(ParserData pd, String filename) {
        try {
            System.err.print("Writing parser in text grammar format to file " + filename);
            BufferedOutputStream os = filename.endsWith(".gz") ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))) : new BufferedOutputStream(new FileOutputStream(filename));
            PrintWriter out2 = new PrintWriter(os);
            String prefix = "BEGIN ";
            out2.println(String.valueOf(prefix) + "OPTIONS");
            if (pd.pt != null) {
                pd.pt.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(String.valueOf(prefix) + "LEXICON");
            if (pd.lex != null) {
                pd.lex.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(String.valueOf(prefix) + "UNARY_GRAMMAR");
            if (pd.ug != null) {
                pd.ug.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(String.valueOf(prefix) + "BINARY_GRAMMAR");
            if (pd.bg != null) {
                pd.bg.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.println(String.valueOf(prefix) + "DEPENDENCY_GRAMMAR");
            if (pd.dg != null) {
                pd.dg.writeData(out2);
            }
            out2.println();
            System.err.print(".");
            out2.flush();
            out2.close();
            System.err.println("done.");
        }
        catch (IOException e) {
            System.err.println("Trouble saving parser data to ASCII format.");
            e.printStackTrace();
        }
    }

    protected static ParserData getParserDataFromTextFile(String textFileOrUrl, Options op) {
        try {
            InputStream is;
            System.err.print("Loading parser from text file " + textFileOrUrl + " ");
            if (textFileOrUrl.startsWith("http://")) {
                URL u = new URL(textFileOrUrl);
                URLConnection uc = u.openConnection();
                is = uc.getInputStream();
            } else {
                is = new FileInputStream(textFileOrUrl);
            }
            BufferedReader in = textFileOrUrl.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(is))) : new BufferedReader(new InputStreamReader(is));
            Timing.startTime();
            String line = in.readLine();
            if (!line.startsWith("BEGIN")) {
                throw new RuntimeException("Didn't expect " + line);
            }
            op.readData(in);
            System.err.print(".");
            line = in.readLine();
            if (!line.startsWith("BEGIN")) {
                throw new RuntimeException("Didn't expect " + line);
            }
            Lexicon lex = op.tlpParams.lex(op.lexOptions);
            lex.readData(in);
            System.err.print(".");
            line = in.readLine();
            if (!line.startsWith("BEGIN")) {
                throw new RuntimeException("Didn't expect " + line);
            }
            UnaryGrammar ug = new UnaryGrammar(op.numStates);
            ug.readData(in);
            System.err.print(".");
            line = in.readLine();
            if (!line.startsWith("BEGIN")) {
                throw new RuntimeException("Didn't expect " + line);
            }
            BinaryGrammar bg = new BinaryGrammar(op.numStates);
            bg.readData(in);
            System.err.print(".");
            line = in.readLine();
            if (!line.startsWith("BEGIN")) {
                throw new RuntimeException("Didn't expect " + line);
            }
            MLEDependencyGrammar dg = new MLEDependencyGrammar(op.tlpParams, op.directional, op.distance, op.coarseDistance);
            dg.readData(in);
            System.err.print(".");
            Map numbs = Numberer.getNumberers();
            in.close();
            System.err.println(" done.");
            return new ParserData(lex, bg, ug, dg, numbs, op);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static ParserData getParserDataFromSerializedFile(String serializedFileOrUrl) {
        try {
            InputStream is;
            Timing tim = new Timing();
            System.err.println("Loading parser from serialized file " + serializedFileOrUrl + "...");
            if (serializedFileOrUrl.startsWith("http://")) {
                URL u = new URL(serializedFileOrUrl);
                URLConnection uc = u.openConnection();
                is = uc.getInputStream();
            } else {
                is = new FileInputStream(serializedFileOrUrl);
            }
            ObjectInputStream in = serializedFileOrUrl.endsWith(".gz") ? new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(is))) : new ObjectInputStream(new BufferedInputStream(is));
            ParserData pd = (ParserData)in.readObject();
            in.close();
            System.err.println("...parser done [" + tim.toSecondsString() + " sec].");
            return pd;
        }
        catch (InvalidClassException ice) {
            System.err.println();
            ice.printStackTrace();
            System.exit(2);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println();
            fnfe.printStackTrace();
            System.exit(2);
        }
        catch (StreamCorruptedException sce) {
            System.err.println();
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
        }
        return null;
    }

    private static void printOptions(boolean train, Options op) {
        op.display();
        if (train) {
            Train.display();
        } else {
            Test.display();
        }
        op.tlpParams.display();
    }

    protected final ParserData getParserDataFromTreebank(Treebank trainTreebank, GrammarCompactor compactor, Treebank tuneTreebank) {
        System.err.println("Currently " + new Date());
        LexicalizedParser.printOptions(true, this.op);
        Timing.startTime();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = tlpParams.treebankLanguagePack();
        if (Test.verbose) {
            System.out.print("Training ");
            System.out.println(trainTreebank.textualSummary());
        }
        System.err.print("Binarizing trees...");
        TreeAnnotatorAndBinarizer binarizer = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, !Train.outsideFactor(), true) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), new LeftHeadFinder(), tlpParams, this.op.forceCNF, !Train.outsideFactor(), true);
        CollinsPuncTransformer collinsPuncTransformer = null;
        if (Train.collinsPunc) {
            collinsPuncTransformer = new CollinsPuncTransformer(tlp);
        }
        ArrayList<Tree> binaryTrainTrees = new ArrayList<Tree>();
        ArrayList<Tree> binaryTuneTrees = new ArrayList<Tree>();
        if (Train.selectiveSplit) {
            Train.splitters = ParentAnnotationStats.getSplitCategories(trainTreebank, Train.tagSelectiveSplit, 0, Train.selectiveSplitCutOff, Train.tagSelectiveSplitCutOff, tlp);
            if (Train.deleteSplitters != null) {
                ArrayList<String> deleted = new ArrayList<String>();
                for (String del : Train.deleteSplitters) {
                    String baseDel = tlp.basicCategory(del);
                    boolean checkBasic = del.equals(baseDel);
                    Iterator it = Train.splitters.iterator();
                    while (it.hasNext()) {
                        boolean delStr;
                        String elem = (String)it.next();
                        String baseElem = tlp.basicCategory(elem);
                        boolean bl = delStr = checkBasic && baseElem.equals(baseDel) || elem.equals(del);
                        if (!delStr) continue;
                        it.remove();
                        deleted.add(elem);
                    }
                }
                if (Test.verbose) {
                    System.err.println("Removed from vertical splitters: " + deleted);
                }
            }
            if (Test.verbose) {
                ArrayList list = new ArrayList(Train.splitters);
                Collections.sort(list);
                System.err.println("Parent split categories: " + list);
            }
        }
        if (Train.selectivePostSplit) {
            TreeAnnotator myTransformer = new TreeAnnotator(tlpParams.headFinder(), tlpParams);
            Treebank annotatedTB = trainTreebank.transform(myTransformer);
            Train.postSplitters = ParentAnnotationStats.getSplitCategories(annotatedTB, true, 0, Train.selectivePostSplitCutOff, Train.tagSelectivePostSplitCutOff, tlp);
            if (Test.verbose) {
                System.err.println("Parent post annotation split categories: " + Train.postSplitters);
            }
        }
        if (Train.hSelSplit) {
            boolean ptt = Train.printTreeTransformations;
            Train.printTreeTransformations = false;
            binarizer.setDoSelectiveSplit(false);
            for (Object tree : trainTreebank) {
                if (Train.collinsPunc) {
                    tree = collinsPuncTransformer.transformTree((Tree)tree);
                }
                binarizer.transformTree((Tree)tree);
            }
            binarizer.setDoSelectiveSplit(true);
            Train.printTreeTransformations = ptt;
        }
        for (Tree tree : trainTreebank) {
            if (Train.collinsPunc) {
                tree = collinsPuncTransformer.transformTree(tree);
            }
            if ((tree = binarizer.transformTree(tree)).yield().size() > trainLengthLimit) continue;
            binaryTrainTrees.add(tree);
        }
        if (tuneTreebank != null) {
            for (Tree tree : tuneTreebank) {
                if (Train.collinsPunc) {
                    tree = collinsPuncTransformer.transformTree(tree);
                }
                if ((tree = binarizer.transformTree(tree)).yield().size() > trainLengthLimit) continue;
                binaryTuneTrees.add(tree);
            }
        }
        Timing.tick("done.");
        if (Test.verbose) {
            binarizer.dumpStats();
        }
        BinaryGrammarExtractor bgExtractor = new BinaryGrammarExtractor();
        Extractor dgExtractor = this.op.tlpParams.dependencyGrammarExtractor(this.op);
        System.err.print("Extracting PCFG...");
        Pair bgug = (Pair)bgExtractor.extract(binaryTrainTrees);
        Timing.tick("done.");
        if (compactor != null) {
            System.err.print("Compacting grammar...");
            bgug = compactor.compactGrammar(bgug);
            Timing.tick("done.");
        }
        System.err.print("Compiling grammar...");
        BinaryGrammar bg = (BinaryGrammar)bgug.second;
        bg.splitRules();
        UnaryGrammar ug = (UnaryGrammar)bgug.first;
        ug.purgeRules();
        Timing.tick("done");
        System.err.print("Extracting Lexicon...");
        Lexicon lex = this.op.tlpParams.lex(this.op.lexOptions);
        lex.train(binaryTrainTrees);
        Timing.tick("done.");
        DependencyGrammar dg = null;
        if (this.op.doDep) {
            System.err.print("Extracting Dependencies...");
            dg = (DependencyGrammar)dgExtractor.extract(binaryTrainTrees);
            Timing.tick("done.");
            if (tuneTreebank != null) {
                System.err.print("Tuning Dependency Model...");
                dg.tune(binaryTuneTrees);
                Timing.tick("done.");
            }
        }
        Map numbs = Numberer.getNumberers();
        int numStates = Numberer.getGlobalNumberer("states").total();
        System.err.println("numStates: " + numStates);
        System.err.println("Done training parser.");
        return new ParserData(lex, bg, ug, dg, numbs, this.op);
    }

    protected final ParserData getParserDataFromTreebank(Treebank trainTreebank, DiskTreebank secondaryTrainTreebank, double weight, GrammarCompactor compactor) {
        System.out.println("Currently " + new Date());
        LexicalizedParser.printOptions(true, this.op);
        Timing.startTime();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = tlpParams.treebankLanguagePack();
        if (Test.verbose) {
            System.out.print("Training ");
            System.out.println(trainTreebank.textualSummary());
        }
        CompositeTreeTransformer trainTransformer = new CompositeTreeTransformer();
        if (Train.collinsPunc) {
            CollinsPuncTransformer collinsPuncTransformer = new CollinsPuncTransformer(tlp);
            trainTransformer.addTransformer(collinsPuncTransformer);
        }
        TreeAnnotatorAndBinarizer binarizer = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, !Train.outsideFactor(), true) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), new LeftHeadFinder(), tlpParams, this.op.forceCNF, !Train.outsideFactor(), true);
        trainTransformer.addTransformer(binarizer);
        CompositeTreebank wholeTreebank = new CompositeTreebank(trainTreebank, secondaryTrainTreebank);
        if (Train.selectiveSplit) {
            Train.splitters = ParentAnnotationStats.getSplitCategories(wholeTreebank, Train.tagSelectiveSplit, 0, Train.selectiveSplitCutOff, Train.tagSelectiveSplitCutOff, tlp);
            if (Train.deleteSplitters != null) {
                ArrayList<String> deleted = new ArrayList<String>();
                for (String del : Train.deleteSplitters) {
                    String baseDel = tlp.basicCategory(del);
                    boolean checkBasic = del.equals(baseDel);
                    Iterator it = Train.splitters.iterator();
                    while (it.hasNext()) {
                        boolean delStr;
                        String elem = (String)it.next();
                        String baseElem = tlp.basicCategory(elem);
                        boolean bl = delStr = checkBasic && baseElem.equals(baseDel) || elem.equals(del);
                        if (!delStr) continue;
                        it.remove();
                        deleted.add(elem);
                    }
                }
                if (Test.verbose) {
                    System.err.println("Removed from vertical splitters: " + deleted);
                }
            }
            if (Test.verbose) {
                System.err.println("Parent split categories: " + Train.splitters);
            }
        }
        Treebank transformedWholeTreebank = wholeTreebank;
        if (Train.selectivePostSplit) {
            TreeAnnotator annotator = new TreeAnnotator(tlpParams.headFinder(), tlpParams);
            transformedWholeTreebank = transformedWholeTreebank.transform(annotator);
            Train.postSplitters = ParentAnnotationStats.getSplitCategories(transformedWholeTreebank, true, 0, Train.selectivePostSplitCutOff, Train.tagSelectivePostSplitCutOff, tlp);
            if (Test.verbose) {
                System.err.println("Parent post annotation split categories: " + Train.postSplitters);
            }
        }
        if (Train.hSelSplit) {
            binarizer.setDoSelectiveSplit(false);
            for (Tree tree : transformedWholeTreebank) {
                trainTransformer.transformTree(tree);
            }
            binarizer.setDoSelectiveSplit(true);
        }
        trainTreebank.transform(trainTransformer);
        Treebank transformedSecondaryTrainTreebank = secondaryTrainTreebank.transform(trainTransformer);
        BinaryGrammarExtractor bgExtractor = new BinaryGrammarExtractor();
        MLEDependencyGrammarExtractor dgExtractor = new MLEDependencyGrammarExtractor(this.op);
        System.out.print("Extracting PCFG...");
        Pair bgug = (Pair)bgExtractor.extract(trainTreebank, transformedSecondaryTrainTreebank, weight);
        Timing.tick("done.");
        if (compactor != null) {
            System.out.print("Compacting grammar...");
            bgug = compactor.compactGrammar(bgug);
            Timing.tick("done.");
        }
        System.out.print("Compiling grammar...");
        BinaryGrammar bg = (BinaryGrammar)bgug.second;
        bg.splitRules();
        UnaryGrammar ug = (UnaryGrammar)bgug.first;
        ug.purgeRules();
        Timing.tick("done");
        System.out.print("Extracting Lexicon...");
        Lexicon lex = this.op.tlpParams.lex(this.op.lexOptions);
        lex.train(trainTreebank);
        Timing.tick("done.");
        DependencyGrammar dg = null;
        if (this.op.doDep) {
            System.out.print("Extracting Dependencies...");
            dg = (DependencyGrammar)dgExtractor.extract(trainTreebank, transformedSecondaryTrainTreebank, weight);
            Timing.tick("done.");
        }
        Map numbs = Numberer.getNumberers();
        int numStates = Numberer.getGlobalNumberer("states").total();
        System.out.println("numStates: " + numStates);
        System.err.println("Done training parser.");
        return new ParserData(lex, bg, ug, dg, numbs, this.op);
    }

    protected final void makeParsers() {
        if (this.pd == null) {
            throw new IllegalArgumentException("Error loading parser data: pd null");
        }
        Numberer.setNumberers(this.pd.numbs);
        BinaryGrammar bg = this.pd.bg;
        bg.splitRules();
        UnaryGrammar ug = this.pd.ug;
        Lexicon lex = this.pd.lex;
        DependencyGrammar dg = this.pd.dg;
        this.op = this.pd.pt;
        if (this.op.doPCFG) {
            this.pparser = Test.iterativeCKY ? new IterativeCKYPCFGParser(bg, ug, lex, this.op) : new ExhaustivePCFGParser(bg, ug, lex, this.op);
        }
        if (this.op.doDep) {
            this.dparser = new ExhaustiveDependencyParser(dg, lex, this.op);
            TwinScorer scorer = new TwinScorer(this.pparser, this.dparser);
            if (this.op.doPCFG) {
                this.bparser = new BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op);
            }
        }
        this.fallbackToPCFG = true;
        this.debinarizer = new Debinarizer(this.op.langpack(), this.op.forceCNF);
        this.subcategoryStripper = this.op.tlpParams.subcategoryStripper();
    }

    static Sentence getInputSentence(Tree t) {
        if (Test.forceTags) {
            if (Test.preTag) {
                throw new RuntimeException("Sorry -- haven't implemented support for external tagger yet.");
            }
            return t.taggedYield();
        }
        return t.yield();
    }

    private static int numSubArgs(String[] args, int index) {
        int i = index;
        while (i + 1 < args.length && args[i + 1].charAt(0) != '-') {
            ++i;
        }
        return i - index;
    }

    private static void printOutOfMemory(PrintWriter pw) {
        pw.println();
        pw.println("*******************************************************");
        pw.println("***  WARNING!! OUT OF MEMORY! THERE WAS NOT ENOUGH  ***");
        pw.println("***  MEMORY TO RUN ALL PARSERS.  EITHER GIVE THE    ***");
        pw.println("***  JVM MORE MEMORY, SET THE MAXIMUM SENTENCE      ***");
        pw.println("***  LENGTH WITH -maxLength, OR PERHAPS YOU ARE     ***");
        pw.println("***  HAPPY TO HAVE THE PARSER FALL BACK TO USING    ***");
        pw.println("***  A SIMPLER PARSER FOR VERY LONG SENTENCES.      ***");
        pw.println("*******************************************************");
        pw.println();
    }

    public double testOnTreebank(Treebank testTreebank) {
        System.err.println("Testing on treebank");
        Timing.startTime();
        if (Test.verbose) {
            System.out.print("Testing ");
            System.out.println(testTreebank.textualSummary());
        }
        TreePrint treePrint = this.getTreePrint();
        TreebankLangParserParams tlpParams = this.op.tlpParams;
        TreebankLanguagePack tlp = this.op.langpack();
        if (Test.evalb) {
            EvalB.initEVALBfiles(tlpParams);
        }
        PrintWriter pwOut = tlpParams.pw();
        PrintWriter pwErr = tlpParams.pw(System.err);
        TreeTransformer tc = tlpParams.collinizer();
        BoundaryRemover br = new BoundaryRemover();
        LabeledConstituentEval pcfgPE = new LabeledConstituentEval("pcfg LP/LR", tlp);
        AbstractEval.DependencyEval depDE = new AbstractEval.DependencyEval("depend DE", tlp.punctuationWordAcceptFilter());
        LabeledConstituentEval comboPE = new LabeledConstituentEval("factor LP/LR", tlp);
        AbstractEval.RuleErrorEval ruleErrorEval = null;
        AbstractEval.CatErrorEval catErrorEval = null;
        if (Test.verbose) {
            ruleErrorEval = new AbstractEval.RuleErrorEval("Rule under/over");
            catErrorEval = new AbstractEval.CatErrorEval("Category under/over");
        }
        AbstractEval.TaggingEval comboTE = new AbstractEval.TaggingEval("Tag", this.pd.lex);
        TreeAnnotatorAndBinarizer binarizerOnly = !Train.leftToRight ? new TreeAnnotatorAndBinarizer(tlpParams, this.op.forceCNF, false, false) : new TreeAnnotatorAndBinarizer(tlpParams.headFinder(), new LeftHeadFinder(), tlpParams, this.op.forceCNF, false, false);
        boolean saidMemMessage = false;
        boolean outsideLengthBound = false;
        Timing timer = new Timing();
        for (Tree goldTree : testTreebank) {
            List<Tree> parses;
            int sz;
            outsideLengthBound = false;
            Sentence s = LexicalizedParser.getInputSentence(goldTree);
            timer.start();
            pwErr.println("Parsing [len. " + s.length() + "]: " + s);
            Tree tree = null;
            try {
                if (!this.parse(s)) {
                    pwErr.print("Sentence couldn't be parsed by grammar.");
                    if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                        pwErr.println("... falling back to PCFG parse.");
                        tree = this.getBestPCFGParse();
                    } else {
                        pwErr.println();
                    }
                } else {
                    tree = this.getBestParse();
                }
            }
            catch (OutOfMemoryError e) {
                if (Test.maxLength != 559038737) {
                    pwErr.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + Test.maxLength);
                    throw e;
                }
                if (!saidMemMessage) {
                    LexicalizedParser.printOutOfMemory(pwErr);
                    saidMemMessage = true;
                }
                if (this.pparser.hasParse() && this.fallbackToPCFG) {
                    try {
                        String what = "dependency";
                        if (this.dparser.hasParse()) {
                            what = "factored";
                        }
                        pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                        tree = this.getBestPCFGParse();
                    }
                    catch (OutOfMemoryError oome) {
                        oome.printStackTrace();
                        pwErr.println("No memory to gather PCFG parse. Skipping...");
                        this.pparser.nudgeDownArraySize();
                    }
                } else {
                    pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                }
                pwErr.println();
            }
            catch (UnsupportedOperationException uoe) {
                pwErr.println("Sentence too long (or zero words).");
                outsideLengthBound = true;
            }
            if (Test.verbose) {
                pwOut.println("ComboParser best");
                Tree ot = tree;
                if (ot != null && !tlpParams.treebankLanguagePack().isStartSymbol(ot.value())) {
                    ot = ot.treeFactory().newTreeNode(tlpParams.treebankLanguagePack().startSymbol(), Collections.singletonList(ot));
                }
                treePrint.printTree(ot, pwOut);
            } else {
                treePrint.printTree(tree, pwOut);
            }
            if (tree != null && Test.printAllBestParses && (sz = (parses = this.pparser.getBestParses()).size()) > 1) {
                pwOut.println("There were " + sz + " best PCFG parses.");
                Tree transGoldTree = tc.transformTree(goldTree);
                for (Tree tb : parses) {
                    Tree tbd = this.debinarizer.transformTree(tb);
                    tbd = this.subcategoryStripper.transformTree(tbd);
                    Tree tbtr = tc.transformTree(tbd);
                    pwOut.println("Tree size = " + tbtr.size() + "; depth = " + tbtr.depth());
                    tbtr.pennPrint(pwOut);
                    pcfgPE.evaluate(tbtr, transGoldTree, pwOut);
                }
            }
            if (Test.verbose && !outsideLengthBound) {
                pwOut.println("Correct parse");
                treePrint.printTree(goldTree, pwOut);
            }
            timer.report("Parsing Sentence");
            if (tree != null) {
                Tree treeDep;
                Tree transGoldTree = tc.transformTree(goldTree);
                if (transGoldTree == null) {
                    pwErr.println("Couldn't transform gold tree for evaluation, skipping eval. Gold tree was:");
                    goldTree.pennPrint(pwErr);
                    continue;
                }
                Tree treePCFG = this.getBestPCFGParse();
                if (treePCFG != null) {
                    pcfgPE.evaluate(tc.transformTree(treePCFG), transGoldTree, pwErr);
                    if (Test.verbose) {
                        ((AbstractEval)ruleErrorEval).evaluate(tc.transformTree(treePCFG), transGoldTree, pwErr);
                        ((AbstractEval)catErrorEval).evaluate(tc.transformTree(treePCFG), transGoldTree, pwErr);
                    }
                }
                if ((treeDep = this.getBestDependencyParse()) != null) {
                    depDE.evaluate(treeDep, binarizerOnly.transformTree(goldTree), pwErr);
                }
                comboPE.evaluate(tc.transformTree(tree), transGoldTree, pwErr);
                ((AbstractEval)comboTE).evaluate(tree, br.transformTree(goldTree), pwErr);
                if (Test.evalb) {
                    LexicalizedParser.nanScores(tree);
                    EvalB.writeEVALBline(goldTree, tree);
                }
            }
            pwErr.println();
        }
        Timing.tick("Done testing on treebank");
        if (saidMemMessage) {
            LexicalizedParser.printOutOfMemory(pwErr);
        }
        if (Test.evalb) {
            EvalB.closeEVALBfiles();
        }
        if (Test.verbose) {
            ((AbstractEval)ruleErrorEval).display(true, pwErr);
            ((AbstractEval)catErrorEval).display(true, pwErr);
        }
        return comboPE.getEvalbF1();
    }

    private static void nanScores(Tree tree) {
        tree.setScore(Double.NaN);
        Tree[] kids = tree.children();
        int i = 0;
        while (i < kids.length) {
            LexicalizedParser.nanScores(kids[i]);
            ++i;
        }
    }

    private void parseFiles(String[] args, int argIndex, boolean tokenized, TokenizerFactory tokenizerFactory, DocumentPreprocessor documentPreprocessor, boolean fromXML, String sentenceDelimiter, Function<List<HasWord>, List<HasWord>> escaper, int tagDelimiter) {
        PrintWriter pwOut = this.op.tlpParams.pw();
        PrintWriter pwErr = this.op.tlpParams.pw(System.err);
        TreePrint treePrint = this.getTreePrint();
        int numWords = 0;
        int numSents = 0;
        int numUnparsable = 0;
        int numNoMemory = 0;
        int numFallback = 0;
        int numSkipped = 0;
        Timing timer = new Timing();
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        if (tokenized) {
            tokenizerFactory = WhitespaceTokenizer.factory();
        }
        if (tokenizerFactory == null) {
            tokenizerFactory = tlp.getTokenizerFactory();
        }
        documentPreprocessor.setTokenizerFactory(tokenizerFactory);
        documentPreprocessor.setSentenceFinalPuncWords(tlp.sentenceFinalPunctuationWords());
        documentPreprocessor.setEncoding(this.op.tlpParams.getInputEncoding());
        boolean saidMemMessage = false;
        timer.start();
        int i = argIndex;
        while (i < args.length) {
            String filename = args[i];
            try {
                List<List<? extends HasWord>> document = fromXML ? documentPreprocessor.getSentencesFromXML(filename, sentenceDelimiter, true) : documentPreprocessor.getSentencesFromText(filename, escaper, sentenceDelimiter, tagDelimiter);
                System.err.println("Parsing file: " + filename + " with " + document.size() + " sentences.");
                PrintWriter pwo = pwOut;
                if (Test.writeOutputFiles) {
                    String ext = Test.outputFilesExtension == null ? "stp" : Test.outputFilesExtension;
                    String fname = String.valueOf(filename) + "." + ext;
                    if (Test.outputFilesDirectory != null) {
                        String fseparator = System.getProperty("file.separator");
                        if (fseparator == null || fseparator.equals("")) {
                            fseparator = "/";
                        }
                        int ind = fname.lastIndexOf(fseparator);
                        fname = fname.substring(ind + 1);
                        if (!"".equals(Test.outputFilesDirectory)) {
                            fname = String.valueOf(Test.outputFilesDirectory) + fseparator + fname;
                        }
                    }
                    try {
                        pwo = this.op.tlpParams.pw(new FileOutputStream(fname));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                int num = 0;
                treePrint.printHeader(pwo, this.op.tlpParams.getOutputEncoding());
                for (List<? extends HasWord> sentence : document) {
                    ++numSents;
                    int len = sentence.size();
                    numWords += len;
                    pwErr.println("Parsing [sent. " + ++num + " len. " + len + "]: " + sentence);
                    Tree ansTree = null;
                    try {
                        if (!this.parse(sentence)) {
                            pwErr.print("Sentence couldn't be parsed by grammar.");
                            if (this.pparser != null && this.pparser.hasParse() && this.fallbackToPCFG) {
                                pwErr.println("... falling back to PCFG parse.");
                                ansTree = this.getBestPCFGParse();
                                ++numFallback;
                            } else {
                                pwErr.println();
                                ++numUnparsable;
                            }
                        } else {
                            ansTree = this.getBestParse();
                        }
                    }
                    catch (OutOfMemoryError e) {
                        if (Test.maxLength != 559038737) {
                            pwErr.println("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH " + Test.maxLength);
                            throw e;
                        }
                        if (!saidMemMessage) {
                            LexicalizedParser.printOutOfMemory(pwErr);
                            saidMemMessage = true;
                        }
                        if (this.pparser.hasParse() && this.fallbackToPCFG) {
                            try {
                                String what = "dependency";
                                if (this.dparser.hasParse()) {
                                    what = "factored";
                                }
                                pwErr.println("Sentence too long for " + what + " parser.  Falling back to PCFG parse...");
                                ansTree = this.getBestPCFGParse();
                                ++numFallback;
                            }
                            catch (OutOfMemoryError oome) {
                                oome.printStackTrace();
                                ++numNoMemory;
                                pwErr.println("No memory to gather PCFG parse. Skipping...");
                                this.pparser.nudgeDownArraySize();
                            }
                        } else {
                            pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
                            ++numSkipped;
                        }
                    }
                    catch (UnsupportedOperationException uoe) {
                        pwErr.println("Sentence too long (or zero words).");
                        numWords -= len;
                        ++numSkipped;
                    }
                    try {
                        treePrint.printTree(ansTree, Integer.toString(num), pwo);
                    }
                    catch (RuntimeException re) {
                        pwErr.println("TreePrint.printTree skipped: out of memory");
                        re.printStackTrace();
                        ++numNoMemory;
                        try {
                            treePrint.printTree(null, Integer.toString(num), pwo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                treePrint.printFooter(pwo);
                if (Test.writeOutputFiles) {
                    pwo.close();
                }
                System.err.println("Parsed file: " + filename + " [" + num + " sentences].");
            }
            catch (IOException e) {
                pwErr.println("ERROR: Couldn't open file: " + filename);
            }
            ++i;
        }
        long millis = timer.stop();
        if (saidMemMessage) {
            LexicalizedParser.printOutOfMemory(pwErr);
        }
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        double sentspersec = (double)numSents / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        pwErr.println("Parsed " + numWords + " words in " + numSents + " sentences (" + nf.format(wordspersec) + " wds/sec; " + nf.format(sentspersec) + " sents/sec).");
        if (numFallback > 0) {
            pwErr.println("  " + numFallback + " sentences were parsed by fallback to PCFG.");
        }
        if (numUnparsable > 0 || numNoMemory > 0 || numSkipped > 0) {
            pwErr.println("  " + (numUnparsable + numNoMemory + numSkipped) + " sentences were not parsed:");
            if (numUnparsable > 0) {
                pwErr.println("    " + numUnparsable + " were not parsable with non-zero probability.");
            }
            if (numNoMemory > 0) {
                pwErr.println("    " + numNoMemory + " were skipped because of insufficient memory.");
            }
            if (numSkipped > 0) {
                pwErr.println("    " + numSkipped + " were skipped as length 0 or greater than " + Test.maxLength);
            }
        }
    }

    public void setOptionFlags(String[] flags) {
        int i = 0;
        while (i < flags.length) {
            int j = FactoredParser.setOptionFlag(this.op, flags, i);
            if (j == i && (j = this.op.tlpParams.setOptionFlag(flags, i)) == i) {
                throw new IllegalArgumentException("Unknown option: " + flags[i]);
            }
            i = j;
        }
    }

    private static void printArgs(String[] args, PrintStream ps) {
        ps.print("LexicalizedParser invoked with arguments:");
        int i = 0;
        while (i < args.length) {
            ps.print(" " + args[i]);
            ++i;
        }
        ps.println();
    }

    public static void main(String[] args) {
        boolean train = false;
        boolean saveToSerializedFile = false;
        boolean saveToTextFile = false;
        boolean testOnTreebankUsingGoldTags = false;
        String serializedInputFileOrUrl = null;
        String textInputFileOrUrl = null;
        String serializedOutputFileOrUrl = null;
        String textOutputFileOrUrl = null;
        String treebankPath = null;
        MemoryTreebank testTreebank = null;
        MemoryTreebank tuneTreebank = null;
        String testPath = null;
        FileFilter testFilter = null;
        String tunePath = null;
        FileFilter tuneFilter = null;
        FileFilter trainFilter = null;
        String secondaryTreebankPath = null;
        double secondaryTreebankWeight = 1.0;
        NumberRangesFileFilter secondaryTrainFilter = null;
        TokenizerFactory tokenizerFactory = null;
        DocumentPreprocessor documentPreprocessor = new DocumentPreprocessor();
        boolean tokenized = false;
        Function escaper = null;
        int tagDelimiter = -1;
        String sentenceDelimiter = null;
        boolean fromXML = false;
        int argIndex = 0;
        if (args.length < 1) {
            System.err.println("usage: java edu.stanford.nlp.parser.lexparser.LexicalizedParser parserFileOrUrl filename*");
            System.exit(1);
        }
        Options op = new Options();
        String encoding = null;
        while (argIndex < args.length && args[argIndex].charAt(0) == '-') {
            int high;
            if (args[argIndex].equalsIgnoreCase("-train") || args[argIndex].equalsIgnoreCase("-trainTreebank")) {
                train = true;
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs > 1) {
                    treebankPath = args[argIndex];
                    ++argIndex;
                } else {
                    throw new RuntimeException("Error: -train option must have treebankPath as first argument.");
                }
                if (numSubArgs == 2) {
                    trainFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs < 3) continue;
                try {
                    int low = Integer.parseInt(args[argIndex]);
                    high = Integer.parseInt(args[argIndex + 1]);
                    trainFilter = new NumberRangeFileFilter(low, high, true);
                    argIndex += 2;
                }
                catch (NumberFormatException e) {
                    trainFilter = new NumberRangesFileFilter(args[argIndex], true);
                    ++argIndex;
                }
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-train2")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs < 3) {
                    throw new RuntimeException("Error: -train2 <treebankPath> <ranges> <weight>.");
                }
                secondaryTreebankPath = args[argIndex++];
                secondaryTrainFilter = new NumberRangesFileFilter(args[argIndex++], true);
                secondaryTreebankWeight = Double.parseDouble(args[argIndex++]);
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tLPP") && argIndex + 1 < args.length) {
                try {
                    op.tlpParams = (TreebankLangParserParams)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Class not found: " + args[argIndex + 1]);
                }
                catch (InstantiationException e) {
                    System.err.println("Couldn't instantiate: " + args[argIndex + 1] + ": " + e.toString());
                }
                catch (IllegalAccessException e) {
                    System.err.println("Illegal access" + e);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-encoding")) {
                encoding = args[argIndex + 1];
                op.tlpParams.setInputEncoding(encoding);
                op.tlpParams.setOutputEncoding(encoding);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-useBasicCategoryTagsInDependencyGrammar")) {
                basicCategoryTagsInDependencyGrammar = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tokenized")) {
                tokenized = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-escaper")) {
                try {
                    escaper = (Function)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate escaper " + args[argIndex + 1] + ": " + e);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tokenizerFactory")) {
                try {
                    tokenizerFactory = (TokenizerFactory)Class.forName(args[argIndex + 1]).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Couldn't instantiate TokenizerFactory " + args[argIndex + 1]);
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-sentences")) {
                sentenceDelimiter = args[argIndex + 1];
                if (sentenceDelimiter.equalsIgnoreCase("newline")) {
                    sentenceDelimiter = "\n";
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parseInside")) {
                sentenceDelimiter = args[argIndex + 1];
                fromXML = true;
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tagSeparator")) {
                tagDelimiter = args[argIndex + 1].charAt(0);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-loadFromSerializedFile")) {
                serializedInputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-loadFromTextFile")) {
                textInputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveToSerializedFile")) {
                saveToSerializedFile = true;
                if (LexicalizedParser.numSubArgs(args, argIndex) < 1) {
                    System.err.println("Missing path: -saveToSerialized filename");
                } else {
                    serializedOutputFileOrUrl = args[argIndex + 1];
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-saveToTextFile")) {
                saveToTextFile = true;
                textOutputFileOrUrl = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-trainLength")) {
                trainLengthLimit = Integer.parseInt(args[argIndex + 1]);
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-lengthNormalization")) {
                Test.lengthNormalization = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-treebank") || args[argIndex].equalsIgnoreCase("-testTreebank")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs == 1) {
                    testFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs <= 1) continue;
                testPath = args[argIndex++];
                if (numSubArgs == 2) {
                    testFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs < 3) continue;
                try {
                    int low = Integer.parseInt(args[argIndex]);
                    high = Integer.parseInt(args[argIndex + 1]);
                    testFilter = new NumberRangeFileFilter(low, high, true);
                    argIndex += 2;
                }
                catch (NumberFormatException e) {
                    testFilter = new NumberRangesFileFilter(args[argIndex++], true);
                }
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-tune")) {
                int numSubArgs = LexicalizedParser.numSubArgs(args, argIndex);
                ++argIndex;
                if (numSubArgs == 1) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs <= 1) continue;
                tunePath = args[argIndex++];
                if (numSubArgs == 2) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                    continue;
                }
                if (numSubArgs < 3) continue;
                try {
                    int low = Integer.parseInt(args[argIndex]);
                    high = Integer.parseInt(args[argIndex + 1]);
                    tuneFilter = new NumberRangeFileFilter(low, high, true);
                    argIndex += 2;
                }
                catch (NumberFormatException e) {
                    tuneFilter = new NumberRangesFileFilter(args[argIndex++], true);
                }
                continue;
            }
            int j = FactoredParser.setOptionFlag(op, args, argIndex);
            if (j == argIndex) {
                j = op.tlpParams.setOptionFlag(args, argIndex);
            }
            if (j == argIndex) {
                System.err.println("Unknown option ignored: " + args[argIndex]);
            }
            argIndex = ++j;
        }
        if (tuneFilter != null) {
            if (tunePath == null) {
                if (treebankPath == null) {
                    throw new RuntimeException("No tune treebank path specified...");
                }
                System.err.println("No tune treebank path specified.  Using train path: \"" + treebankPath + "\"");
                tunePath = treebankPath;
            }
            tuneTreebank = op.tlpParams.testMemoryTreebank();
            tuneTreebank.loadPath(tunePath, tuneFilter);
        }
        LexicalizedParser lp = null;
        if (!train && Test.verbose) {
            System.err.println("Currently " + new Date());
            LexicalizedParser.printArgs(args, System.err);
        }
        if (train) {
            LexicalizedParser.printArgs(args, System.err);
            ExactGrammarCompactor compactor = null;
            if (Train.compactGrammar() == 3) {
                compactor = new ExactGrammarCompactor(false, false);
            }
            Treebank trainTreebank = LexicalizedParser.makeTreebank(treebankPath, op, trainFilter);
            if (secondaryTreebankPath != null) {
                System.err.println("Additionally training using secondary treebank dir: " + secondaryTreebankPath);
                DiskTreebank secondaryTrainTreebank = LexicalizedParser.makeSecondaryTreebank(secondaryTreebankPath, op, secondaryTrainFilter);
                lp = new LexicalizedParser(trainTreebank, secondaryTrainTreebank, secondaryTreebankWeight, compactor, op);
            } else {
                lp = new LexicalizedParser(trainTreebank, compactor, op, tuneTreebank);
            }
        } else if (textInputFileOrUrl != null) {
            lp = new LexicalizedParser(textInputFileOrUrl, true, op);
        } else {
            if (serializedInputFileOrUrl == null && argIndex < args.length) {
                serializedInputFileOrUrl = args[argIndex];
                ++argIndex;
            }
            if (serializedInputFileOrUrl == null) {
                System.err.println("No grammar specified, exiting...");
                System.exit(0);
            }
            try {
                lp = new LexicalizedParser(serializedInputFileOrUrl, op);
                op = lp.op;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error loading parser, exiting...");
                System.exit(0);
            }
        }
        if (encoding != null) {
            op.tlpParams.setInputEncoding(encoding);
            op.tlpParams.setOutputEncoding(encoding);
        }
        if (testFilter != null || testPath != null) {
            if (testPath == null) {
                if (treebankPath == null) {
                    throw new RuntimeException("No test treebank path specified...");
                }
                System.err.println("No test treebank path specified.  Using train path: \"" + treebankPath + "\"");
                testPath = treebankPath;
            }
            testTreebank = op.tlpParams.testMemoryTreebank();
            testTreebank.loadPath(testPath, testFilter);
        }
        Train.sisterSplitters = new HashSet(Arrays.asList(op.tlpParams.sisterSplitters()));
        if (Test.verbose) {
            System.err.println("ParserPack is " + op.tlpParams.getClass().getName());
            System.err.println("Lexicon is " + lp.pd.lex.getClass().getName());
        }
        if (saveToTextFile) {
            if (textOutputFileOrUrl != null) {
                LexicalizedParser.saveParserDataToText(lp.pd, textOutputFileOrUrl);
            } else {
                System.err.println("Usage: must specify a text grammar output path");
            }
        }
        if (saveToSerializedFile) {
            if (serializedOutputFileOrUrl != null) {
                LexicalizedParser.saveParserDataToSerialized(lp.pd, serializedOutputFileOrUrl);
            } else if (textOutputFileOrUrl == null && testTreebank == null) {
                System.err.println("usage: java edu.stanford.nlp.parser.lexparser.LexicalizedParser -train trainFilesPath [fileRange] -saveToSerializedFile serializedParserFilename");
            }
        }
        if (Test.verbose) {
            LexicalizedParser.printOptions(false, op);
        }
        if (testTreebank != null) {
            lp.testOnTreebank(testTreebank);
        } else if (argIndex >= args.length) {
            PrintWriter pwOut = op.tlpParams.pw();
            PrintWriter pwErr = op.tlpParams.pw(System.err);
            if (lp.parse(op.tlpParams.defaultTestSentence())) {
                Test.treePrint(op.tlpParams).printTree(lp.getBestParse(), pwOut);
            } else {
                pwErr.println("Error. Can't parse test sentence: " + lp.parse(op.tlpParams.defaultTestSentence()));
            }
        } else {
            lp.parseFiles(args, argIndex, tokenized, tokenizerFactory, documentPreprocessor, fromXML, sentenceDelimiter, escaper, tagDelimiter);
        }
    }
}

