/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.ui;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TreeJPanel
extends JPanel {
    int VERTICAL_ALIGN = 0;
    int HORIZONTAL_ALIGN = 0;
    int maxFontSize = 128;
    int minFontSize = 2;
    int preferredX = 400;
    int preferredY = 300;
    double sisterSkip = 2.5;
    double parentSkip = 0.8;
    double belowLineSkip = 0.2;
    double aboveLineSkip = 0.2;
    Tree tree;
    WidthResult wr = new WidthResult();

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
        this.repaint();
    }

    String nodeToString(Tree t) {
        if (t == null) {
            return " ";
        }
        Label l = t.label();
        if (l == null) {
            return " ";
        }
        String str = l.value();
        if (str == null) {
            return " ";
        }
        return str;
    }

    double width(Tree tree, FontMetrics fM) {
        return this.widthResult((Tree)tree, (FontMetrics)fM).width;
    }

    WidthResult widthResult(Tree tree, FontMetrics fM) {
        if (tree == null) {
            this.wr.width = 0.0;
            this.wr.nodeTab = 0.0;
            this.wr.nodeCenter = 0.0;
            this.wr.childTab = 0.0;
            return this.wr;
        }
        double local = fM.stringWidth(this.nodeToString(tree));
        if (tree.isLeaf()) {
            this.wr.width = local;
            this.wr.nodeTab = 0.0;
            this.wr.nodeCenter = local / 2.0;
            this.wr.childTab = 0.0;
            return this.wr;
        }
        double sub = 0.0;
        double nodeCenter = 0.0;
        double childTab = 0.0;
        for (int i = 0; i < tree.children().length; ++i) {
            WidthResult subWR = this.widthResult(tree.children()[i], fM);
            if (i == 0) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            if (i == tree.children().length - 1) {
                nodeCenter += (sub + subWR.nodeCenter) / 2.0;
            }
            sub += subWR.width;
            if (i >= tree.children().length - 1) continue;
            sub += this.sisterSkip * (double)fM.stringWidth(" ");
        }
        double localLeft = local / 2.0;
        double subLeft = nodeCenter;
        double totalLeft = Math.max(localLeft, subLeft);
        double localRight = local / 2.0;
        double subRight = sub - nodeCenter;
        double totalRight = Math.max(localRight, subRight);
        this.wr.width = totalLeft + totalRight;
        this.wr.childTab = totalLeft - subLeft;
        this.wr.nodeTab = totalLeft - localLeft;
        this.wr.nodeCenter = nodeCenter + this.wr.childTab;
        return this.wr;
    }

    double height(Tree tree, FontMetrics fM) {
        if (tree == null) {
            return 0.0;
        }
        double depth = tree.depth();
        return (double)fM.getHeight() * (1.0 + depth * (1.0 + this.parentSkip + this.aboveLineSkip + this.belowLineSkip));
    }

    FontMetrics pickFont(Graphics2D g2, Tree tree, Dimension space) {
        Font font = g2.getFont();
        String name = font.getName();
        int style = font.getStyle();
        for (int size = this.maxFontSize; size > this.minFontSize; --size) {
            font = new Font(name, style, size);
            g2.setFont(font);
            FontMetrics fontMetrics = g2.getFontMetrics();
            if (this.height(tree, fontMetrics) > space.getHeight() || this.width(tree, fontMetrics) > space.getWidth()) continue;
            return fontMetrics;
        }
        font = new Font(name, style, this.minFontSize);
        g2.setFont(font);
        return g2.getFontMetrics();
    }

    double paintTree(Tree t, Point2D start, Graphics2D g2, FontMetrics fM) {
        if (t == null) {
            return 0.0;
        }
        String nodeStr = this.nodeToString(t);
        double nodeWidth = fM.stringWidth(nodeStr);
        double nodeHeight = fM.getHeight();
        double nodeAscent = fM.getAscent();
        WidthResult wr = this.widthResult(t, fM);
        double treeWidth = wr.width;
        double nodeTab = wr.nodeTab;
        double childTab = wr.childTab;
        double nodeCenter = wr.nodeCenter;
        double treeHeight = this.height(t, fM);
        g2.drawString(nodeStr, (float)(nodeTab + start.getX()), (float)(start.getY() + nodeAscent));
        if (t.isLeaf()) {
            return nodeWidth;
        }
        double layerMultiplier = 1.0 + this.belowLineSkip + this.aboveLineSkip + this.parentSkip;
        double layerHeight = nodeHeight * layerMultiplier;
        double childStartX = start.getX() + childTab;
        double childStartY = start.getY() + layerHeight;
        double lineStartX = start.getX() + nodeCenter;
        double lineStartY = start.getY() + nodeHeight * (1.0 + this.belowLineSkip);
        double lineEndY = lineStartY + nodeHeight * this.parentSkip;
        for (int i = 0; i < t.children().length; ++i) {
            Tree child = t.children()[i];
            double cWidth = this.paintTree(child, new Point2D.Double(childStartX, childStartY), g2, fM);
            wr = this.widthResult(child, fM);
            double lineEndX = childStartX + wr.nodeCenter;
            g2.draw(new Line2D.Double(lineStartX, lineStartY, lineEndX, lineEndY));
            childStartX += cWidth;
            if (i >= t.children().length - 1) continue;
            childStartX += this.sisterSkip * (double)fM.stringWidth(" ");
        }
        return treeWidth;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension space = this.getSize();
        FontMetrics fM = this.pickFont(g2, this.tree, space);
        double width = this.width(this.tree, fM);
        double height = this.height(this.tree, fM);
        double startX = 0.0;
        double startY = 0.0;
        if (this.HORIZONTAL_ALIGN == 0) {
            startX = (space.getWidth() - width) / 2.0;
        }
        if (this.HORIZONTAL_ALIGN == 4) {
            startX = space.getWidth() - width;
        }
        if (this.VERTICAL_ALIGN == 0) {
            startY = (space.getHeight() - height) / 2.0;
        }
        if (this.VERTICAL_ALIGN == 3) {
            startY = space.getHeight() - height;
        }
        this.paintTree(this.tree, new Point2D.Double(startX, startY), g2, fM);
    }

    public TreeJPanel() {
        this(0, 0);
    }

    public TreeJPanel(int hAlign, int vAlign) {
        this.HORIZONTAL_ALIGN = hAlign;
        this.VERTICAL_ALIGN = vAlign;
        this.setPreferredSize(new Dimension(400, 300));
    }

    public void setMinFontSize(int size) {
        this.minFontSize = size;
    }

    public void setMaxFontSize(int size) {
        this.maxFontSize = size;
    }

    public static void main(String[] args) throws IOException {
        TreeJPanel tjp = new TreeJPanel();
        String ptbTreeString = "(ROOT (S (NP (DT This)) (VP (VBZ is) (NP (DT a) (NN test))) (. .)))";
        if (args.length > 0) {
            ptbTreeString = args[0];
        }
        Tree tree = new PennTreeReader((Reader)new StringReader(ptbTreeString), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
        tjp.setTree(tree);
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)tjp, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.setVisible(true);
    }

    static class WidthResult {
        double width = 0.0;
        double nodeTab = 0.0;
        double nodeCenter = 0.0;
        double childTab = 0.0;

        WidthResult() {
        }
    }
}

