/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.Function;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Americanize
implements Function {
    private static boolean staticCapitalizeTimex;
    private boolean capitalizeTimex = true;
    public static final int DONT_CAPITALIZE_TIMEX = 1;
    static Pattern[] pats;
    static String[] reps;
    private static final String[] converters;
    private static final String[] converted;
    private static final String[] timexConverters;
    private static final String[] timexConverted;
    private static final HashMap<String, String> mapping;
    private static final HashMap<String, String> timexMapping;

    public Americanize() {
    }

    public Americanize(int flags) {
        if ((flags & 1) != 0) {
            this.capitalizeTimex = false;
        }
    }

    public Object apply(Object in) {
        if (in instanceof HasWord) {
            HasWord w = (HasWord)in;
            String str = w.word();
            String outStr = Americanize.americanize(str, this.capitalizeTimex);
            if (!outStr.equals(str)) {
                w.setWord(outStr);
            }
            return w;
        }
        String str = (String)in;
        return Americanize.americanize(str, this.capitalizeTimex);
    }

    public static String americanize(String str) {
        return Americanize.americanize(str, staticCapitalizeTimex);
    }

    public static String americanize(String str, boolean capitalizeTimex) {
        if (capitalizeTimex && timexMapping.containsKey(str)) {
            return timexMapping.get(str);
        }
        if (mapping.containsKey(str)) {
            return mapping.get(str);
        }
        for (int i = 0; i < pats.length; ++i) {
            Matcher m = pats[i].matcher(str);
            if (!m.find()) continue;
            return m.replaceAll(reps[i]);
        }
        return str;
    }

    public void setStaticCapitalizeTimex(boolean capitalizeTimex) {
        staticCapitalizeTimex = capitalizeTimex;
    }

    public String toString() {
        return "Americanize[capitalizeTimex is " + staticCapitalizeTimex + "; " + "mapping has " + mapping.size() + " mappings; " + "timexMapping has " + timexMapping.size() + " mappings]";
    }

    public static void main(String[] args) {
        System.err.println(new Americanize());
        System.err.println();
        for (String arg : args) {
            System.out.println(arg + " --> " + Americanize.americanize(arg));
        }
    }

    static {
        int i;
        staticCapitalizeTimex = true;
        pats = new Pattern[]{Pattern.compile("haem(at)?o"), Pattern.compile("aemia$"), Pattern.compile("([lL]euk)aem"), Pattern.compile("programme(s?)$"), Pattern.compile("(^[a-z][a-z]{2,})our$")};
        reps = new String[]{"hem$1o", "emia", "$1em", "program$1", "$1or"};
        converters = new String[]{"anaesthetic", "analogue", "analogues", "analyse", "analysed", "analysing", "armour", "armoured", "behaviour", "behaviours", "belabour", "belabours", "cancelled", "cancelling", "candour", "capitalise", "capitalised", "capitalisation", "centre", "chimaeric", "clamour", "colour", "colours", "coloured", "colouring", "defence", "detour", "discolour", "discolours", "discoloured", "discolouring", "endeavour", "endeavours", "endeavoured", "endeavouring", "fervour", "favour", "favours", "favoured", "favouring", "favourite", "favourites", "fibre", "fibres", "finalise", "finalised", "finalising", "flavour", "flavours", "flavoured", "flavouring", "glamour", "grey", "harbour", "harbours", "homologue", "homologues", "honour", "honours", "honoured", "honouring", "honourable", "humour", "humours", "humoured", "humouring", "kerb", "labelled", "labelling", "labour", "labours", "laboured", "labouring", "leant", "learnt", "localise", "localised", "manoeuvre", "manoeuvres", "maximise", "maximised", "maximising", "meagre", "minimise", "minimised", "minimising", "modernise", "modernised", "modernising", "misdemeanour", "misdemeanours", "neighbour", "neighbours", "neighbourhood", "neighbourhoods", "oestrogen", "oestrogens", "organisation", "organisations", "penalise", "penalised", "popularise", "popularised", "popularises", "popularising", "pressurise", "pressurised", "pressurises", "pressurising", "rumour", "rumours", "rumoured", "rumouring", "savour", "savours", "savoured", "savouring", "splendour", "splendours", "theatre", "theatres", "titre", "titres", "travelled", "travelling", "tumour", "tumours", "vapour", "vapours", "vigour"};
        converted = new String[]{"anesthetic", "analog", "analogs", "analyze", "analyzed", "analyzing", "armor", "armored", "behavior", "behaviors", "belabor", "belabors", "canceled", "canceling", "candor", "capitalize", "capitalized", "capitalization", "center", "chimeric", "clamor", "color", "colors", "colored", "coloring", "defense", "detour", "discolor", "discolors", "discolored", "discoloring", "endeavor", "endeavors", "endeavored", "endeavoring", "fervor", "favor", "favors", "favored", "favoring", "favorite", "favorites", "fiber", "fibers", "finalize", "finalized", "finalizing", "flavor", "flavors", "flavored", "flavoring", "glamour", "gray", "harbor", "harbors", "homolog", "homologs", "honor", "honors", "honored", "honoring", "honorable", "humor", "humors", "humored", "humoring", "curb", "labeled", "labeling", "labor", "labors", "labored", "laboring", "leaned", "learned", "localize", "localized", "maneuver", "maneuvers", "maximize", "maximized", "maximizing", "meager", "minimize", "minimized", "minimizing", "modernize", "modernized", "modernizing", "misdemeanor", "misdemeanors", "neighbor", "neighbors", "neighborhood", "neighborhoods", "estrogen", "estrogens", "organization", "organizations", "penalize", "penalized", "popularize", "popularized", "popularizes", "popularizing", "pressurize", "pressurized", "pressurizes", "pressurizing", "rumor", "rumors", "rumored", "rumoring", "savor", "savors", "savored", "savoring", "splendor", "splendors", "theater", "theaters", "titer", "titers", "traveled", "traveling", "tumor", "tumors", "vapor", "vapors", "vigor"};
        timexConverters = new String[]{"january", "february", "april", "june", "july", "august", "september", "october", "november", "december", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        timexConverted = new String[]{"January", "February", "April", "June", "July", "August", "September", "October", "November", "December", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        mapping = new HashMap();
        timexMapping = new HashMap();
        if (converters.length != converted.length || timexConverters.length != timexConverted.length || pats.length != reps.length) {
            throw new RuntimeException("Americanize: Bad initialization data");
        }
        for (i = 0; i < converters.length; ++i) {
            mapping.put(converters[i], converted[i]);
        }
        for (i = 0; i < timexConverters.length; ++i) {
            timexMapping.put(timexConverters[i], timexConverted[i]);
        }
    }
}

