/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.process.Morpha;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Morphology
implements Function {
    private static final boolean DEBUG = false;
    private Morpha lexer;
    private static Morpha staticLexer;
    private static final long serialVersionUID = 2L;

    public Morphology() {
        this.lexer = new Morpha(System.in);
    }

    public Morphology(Reader in) {
        this.lexer = new Morpha(in);
    }

    public Morphology(String filename) {
        try {
            this.lexer = new Morpha(new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Word next() throws IOException {
        return new Word(this.lexer.next());
    }

    static boolean isProper(String posTag) {
        return posTag.equals("NNP") || posTag.equals("NNPS") || posTag.equals("NP");
    }

    public Word stem(Word w) {
        try {
            this.lexer.yyreset(new StringReader(w.value()));
            this.lexer.yybegin(3);
            StringLabel wordRes = this.lexer.next();
            return new Word(wordRes.value());
        }
        catch (Exception e) {
            e.printStackTrace();
            return w;
        }
    }

    public WordTag stem(WordTag wT) {
        return this.stem(wT.word(), wT.tag());
    }

    public WordTag stem(String word, String tag) {
        return Morphology.stem(word, tag, this.lexer, this.lexer.option(1));
    }

    public static WordTag stem(String word, String tag, Morpha lexer, boolean lowercase) {
        boolean wordHasForbiddenChar = word.indexOf("_") >= 0 || word.indexOf(" ") >= 0;
        String quotedWord = word;
        if (wordHasForbiddenChar) {
            try {
                quotedWord = quotedWord.replaceAll("_", "\u0960");
                quotedWord = quotedWord.replaceAll(" ", "\u0961");
            }
            catch (Exception e) {
                System.err.println("stem: Didn't work");
            }
        }
        String wordtag = quotedWord + "_" + tag;
        try {
            lexer.setOption(1, lowercase);
            lexer.yyreset(new StringReader(wordtag));
            lexer.yybegin(4);
            StringLabel wordRes = lexer.next();
            StringLabel tagRes = lexer.next();
            if (wordHasForbiddenChar) {
                try {
                    String w = wordRes.value();
                    w = w.replaceAll("\u0960", "_");
                    w = w.replaceAll("\u0961", " ");
                    wordRes.setValue(w);
                }
                catch (Exception e) {
                    System.err.println("stem: Didn't work");
                }
            }
            return new WordTag(wordRes.value(), tag);
        }
        catch (Throwable e) {
            System.err.println("Morphology.stem() had error on word " + word + "/" + tag);
            return new WordTag(word, tag);
        }
    }

    public static WordTag stemStatic(String word, String tag) {
        if (staticLexer == null) {
            staticLexer = new Morpha(System.in);
        }
        return Morphology.stem(word, tag, staticLexer, staticLexer.option(1));
    }

    public static WordTag stemStatic(String word, String tag, boolean lowercase) {
        if (staticLexer == null) {
            staticLexer = new Morpha(System.in);
        }
        return Morphology.stem(word, tag, staticLexer, lowercase);
    }

    public static WordTag stemStatic(WordTag wT) {
        return Morphology.stemStatic(wT.word(), wT.tag());
    }

    public Object apply(Object in) {
        if (in instanceof WordTag) {
            return this.stem((WordTag)in);
        }
        if (in instanceof Word) {
            return this.stem((Word)in);
        }
        return in;
    }

    public WordLemmaTag lemmatize(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = this.stem(wT).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public static WordLemmaTag lemmatizeStatic(WordTag wT) {
        String tag = wT.tag();
        String word = wT.word();
        String lemma = Morphology.stemStatic(wT).word();
        return new WordLemmaTag(word, lemma, tag);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("John/NNP -> " + Morphology.stemStatic(new WordTag("John", "NNP")));
            System.out.println("Corporations/NNPS -> " + Morphology.stemStatic(new WordTag("Corporations", "NNPS")));
            WordTag hunt = new WordTag("hunting", "V");
            System.out.println("hunting/V -> " + Morphology.stemStatic(hunt));
            System.out.println("hunting/V -> " + Morphology.lemmatizeStatic(hunt));
            String[] exWords = new String[]{"brethren", "ducks", "saw", "saw", "running", "runing", "making", "makking", "stopped", "stoped", "xopped", "won't", "cleaner", "cleaner", "took", "bought", "am", "were", "did", "n't", "wo", "'s", "'s", "ca", "her", "her", "their", "Books", "light-weight", "cease-fire", "John_William_Smith", "Dogs"};
            String[] exTags = new String[]{"NNS", "NNS", "VBD", "NN", "VBG", "VBG", "VBG", "VBG", "VBD", "VBD", "VBD", "MD", "NN", "JJR", "VBD", "VBD", "VBP", "VBD", "VBD", "RB", "MD", "VBZ", "POS", "MD", "PRP", "PRP$", "PRP$", "NNPS", "JJ", "NN", "NNP", "NNS"};
            for (int i = 0; i < exWords.length; ++i) {
                System.out.println(exWords[i] + "/" + exTags[i] + " -> " + Morphology.lemmatizeStatic(new WordTag(exWords[i], exTags[i])));
            }
        } else if (args.length == 2 && args[0].equals("-rebuildVerbTable")) {
            String verbs = StringUtils.slurpFile(args[1]);
            String[] words = verbs.split("\\s+");
            System.out.print(" private static String[] verbStems = new String[] { ");
            for (int i = 0; i < words.length; ++i) {
                System.out.print("\"" + words[i] + "\"");
                if (i == words.length - 1) continue;
                System.out.print(", ");
                if (i % 5 != 0) continue;
                System.out.println();
                System.out.print("    ");
            }
            System.out.println(" };");
        } else if (args[0].equals("-stem")) {
            for (int i = 1; i < args.length; ++i) {
                System.out.println(args[i] + " --> " + Morphology.stemStatic(WordTag.valueOf(args[i])));
            }
        } else {
            for (String arg : args) {
                Word next;
                Morphology morph = new Morphology(arg);
                while ((next = morph.next()) != null) {
                    System.out.print(next);
                }
            }
        }
    }
}

