/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CTBunkDict {
    private static final String defaultFilename = "/juice/scr1/htseng/maxent/maxent-20040930/pos-task4/data/genfeature/ctb_amb.s";
    private static CTBunkDict CTBunkDictSingleton = null;
    public static HashMap<String, Set<String>> CTBunk_dict;

    public static CTBunkDict getInstance() {
        if (CTBunkDictSingleton == null) {
            CTBunkDictSingleton = new CTBunkDict(0);
        }
        return CTBunkDictSingleton;
    }

    private CTBunkDict(int i) {
        CTBunkDict.readCTBunkDict(defaultFilename);
    }

    private static void readCTBunkDict(String filename) {
        try {
            String CTBunkDetectorLine;
            BufferedReader CTBunkDetectorReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GB18030"));
            CTBunk_dict = new HashMap();
            while ((CTBunkDetectorLine = CTBunkDetectorReader.readLine()) != null) {
                String[] fields = CTBunkDetectorLine.split(" ");
                String tag = fields[1];
                Set<String> words = CTBunk_dict.get(tag);
                if (words == null) {
                    words = new HashSet<String>();
                    CTBunk_dict.put(tag, words);
                }
                words.add(fields[0]);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("CTBunk not found");
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("CTBunk");
            System.exit(-1);
        }
    }

    public static String getTag(String a1, String a2) {
        CTBunkDict dict = CTBunkDict.getInstance();
        if (dict.get(a1) == null) {
            return "0";
        }
        if (dict.get(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    Set get(String a) {
        return CTBunk_dict.get(a);
    }
}

