/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

public class History {
    int start;
    int end;
    int current;

    public History() {
    }

    public History(int start, int end, int current) {
        this.start = start;
        this.end = end;
        this.current = current;
        this.init();
    }

    public void save(OutDataStreamFile rf) {
        try {
            rf.writeInt(this.start);
            rf.writeInt(this.end);
            rf.writeInt(this.current);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile rf) {
        try {
            this.start = rf.readInt();
            this.end = rf.readInt();
            this.current = rf.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getX(int index) {
        return GlobalHolder.extractors.get(index).extract(this);
    }

    public String getX(int index, PairsHolder pH) {
        return GlobalHolder.extractors.get(index).extract(this, pH);
    }

    public String[] getX() {
        String[] x = new String[GlobalHolder.extractors.getSize()];
        int i = 0;
        while (i < x.length) {
            x[i] = this.getX(i);
            ++i;
        }
        return x;
    }

    public void print() {
        String[] str = this.getX();
        int i = 0;
        while (i < str.length) {
            System.out.print(String.valueOf(str[i]) + "\t");
            ++i;
        }
        System.out.println();
    }

    public void printSent() {
        this.print();
        int i = this.start;
        while (i < this.end) {
            System.out.print(String.valueOf(GlobalHolder.pairs.get(i, true)) + " " + GlobalHolder.pairs.get(i, false) + "\t");
            ++i;
        }
        System.out.println();
    }

    public void setTag(int pos, String tag) {
        GlobalHolder.pairs.setTag(pos + this.start, tag);
    }

    public String[] getX(PairsHolder pH) {
        String[] x = new String[GlobalHolder.extractors.getSize()];
        int i = 0;
        while (i < x.length) {
            x[i] = this.getX(i, pH);
            ++i;
        }
        return x;
    }

    public void set(int start, int end, int current) {
        this.start = start;
        this.end = end;
        this.current = current;
        this.init();
    }

    public void init() {
    }

    public int hashCode() {
        String s = "";
        int i = 0;
        while (i < GlobalHolder.extractors.getSize()) {
            s = String.valueOf(s) + this.getX(i);
            ++i;
        }
        return s.hashCode();
    }

    public boolean equals(Object h1) {
        if (!(h1 instanceof History)) {
            return false;
        }
        return GlobalHolder.extractors.equals(this, (History)h1);
    }
}

