/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.Serializable;
import java.util.HashMap;

public abstract class AbstractCollinsHeadFinder
implements HeadFinder,
Serializable {
    private static final boolean DEBUG = false;
    protected final TreebankLanguagePack tlp;
    protected HashMap<String, String[][]> nonTerminalInfo;
    protected String[] defaultRule = null;
    private static final long serialVersionUID = -6540278059442931087L;

    protected AbstractCollinsHeadFinder(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    protected Tree findMarkedHead(Tree t) {
        return null;
    }

    public Tree determineHead(Tree t) {
        if (this.nonTerminalInfo == null) {
            throw new RuntimeException("Classes derived from AbstractCollinsHeadFinder must create and fill HashMap nonTerminalInfo.");
        }
        if (t.isLeaf()) {
            return null;
        }
        Tree[] kids = t.children();
        Tree theHead = this.findMarkedHead(t);
        if (theHead != null) {
            return theHead;
        }
        if (kids.length == 1) {
            return kids[0];
        }
        return this.determineNonTrivialHead(t);
    }

    protected Tree determineNonTrivialHead(Tree t) {
        Tree theHead = null;
        String motherCat = this.tlp.basicCategory(t.label().value());
        String[][] how = this.nonTerminalInfo.get(motherCat);
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(t.children(), this.defaultRule, true);
            }
            return null;
        }
        for (int i = 0; i < how.length; ++i) {
            boolean deflt = i == how.length - 1;
            theHead = this.traverseLocate(t.children(), how[i], deflt);
            if (theHead != null) break;
        }
        return theHead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Tree traverseLocate(Tree[] daughterTrees, String[] how, boolean deflt) {
        int headIdx = 0;
        boolean found = false;
        if (how[0].equals("left")) {
            block0: for (int i = 1; i < how.length; ++i) {
                for (headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block0;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = 0;
            }
        } else if (how[0].equals("leftdis")) {
            block2: for (headIdx = 0; headIdx < daughterTrees.length; ++headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                for (int i = 1; i < how.length; ++i) {
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block2;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = 0;
            }
        } else if (how[0].equals("right")) {
            block4: for (int i = 1; i < how.length; ++i) {
                for (headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                    String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block4;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = daughterTrees.length - 1;
            }
        } else {
            if (!how[0].equals("rightdis")) throw new RuntimeException("ERROR: invalid direction type to nonTerminalInfo map in AbstractCollinsHeadFinder.");
            block6: for (headIdx = daughterTrees.length - 1; headIdx >= 0; --headIdx) {
                String childCat = this.tlp.basicCategory(daughterTrees[headIdx].label().value());
                for (int i = 1; i < how.length; ++i) {
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block6;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = daughterTrees.length - 1;
            }
        }
        headIdx = this.postOperationFix(headIdx, daughterTrees);
        return daughterTrees[headIdx];
    }

    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        return headIdx;
    }
}

