/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraph;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GrammaticalStructure
extends TreeGraph
implements Serializable {
    protected Set<Dependency> dependencies = null;
    protected Collection<TypedDependency> typedDependencies = null;
    protected Collection<TypedDependency> allTypedDependencies = null;

    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, HeadFinder hf, Filter puncFilter) {
        super(t);
        this.root.percolateHeads(hf);
        this.dependencies = this.root.dependencies(new NoPunctFilter(puncFilter));
        for (Dependency p : this.dependencies) {
            TreeGraphNode gov = (TreeGraphNode)p.governor();
            TreeGraphNode dep = (TreeGraphNode)p.dependent();
            dep.addArc(GrammaticalRelation.GOVERNOR, gov);
        }
        this.analyzeNode(this.root, this.root, relations);
        this.typedDependencies = this.getDeps(false);
        this.allTypedDependencies = this.getDeps(true);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        return sb.toString();
    }

    private void analyzeNode(TreeGraphNode t, TreeGraphNode root, Collection<GrammaticalRelation> relations) {
        if (t.numChildren() > 0) {
            TreeGraphNode tHigh = t.highestNodeWithSameHead();
            for (GrammaticalRelation egr : relations) {
                if (!egr.isApplicable(t)) continue;
                for (Tree u : egr.getRelatedNodes(t, root)) {
                    tHigh.addArc(egr, (TreeGraphNode)u);
                }
            }
            for (Tree kid : t.children()) {
                this.analyzeNode((TreeGraphNode)kid, root, relations);
            }
        }
    }

    public Collection<TypedDependency> getDeps(boolean extra) {
        ArrayList<TypedDependency> basicDep = new ArrayList<TypedDependency>();
        for (Dependency d : this.dependencies()) {
            TreeGraphNode gov = (TreeGraphNode)d.governor();
            TreeGraphNode dep = (TreeGraphNode)d.dependent();
            GrammaticalRelation reln = this.getGrammaticalRelation(gov, dep);
            basicDep.add(new TypedDependency(reln, gov, dep));
        }
        if (extra) {
            TreeGraphNode root = this.root();
            this.getDep(root, root, basicDep);
        }
        Collections.sort(basicDep);
        return basicDep;
    }

    private void getDep(TreeGraphNode t, TreeGraphNode root, List<TypedDependency> basicDep) {
        if (t.numChildren() > 0) {
            Map depMap = this.getAllDependents(t);
            for (Object depName : depMap.keySet()) {
                for (Object depNode : (HashSet)depMap.get(depName)) {
                    List<GrammaticalRelation> rels;
                    TreeGraphNode dep;
                    TreeGraphNode gov = t.headWordNode();
                    if (gov == (dep = ((TreeGraphNode)depNode).headWordNode()) || (rels = this.getListGrammaticalRelation(t, (TreeGraphNode)depNode)).isEmpty()) continue;
                    for (GrammaticalRelation rel : rels) {
                        TypedDependency newDep = new TypedDependency(rel, gov, dep);
                        if (basicDep.contains(newDep)) continue;
                        basicDep.add(newDep);
                    }
                }
            }
            for (Tree kid : t.children()) {
                this.getDep((TreeGraphNode)kid, root, basicDep);
            }
        }
    }

    public Set<Dependency> dependencies() {
        return this.dependencies;
    }

    public Set getDependents(TreeGraphNode t) {
        HashSet<TreeGraphNode> deps = new HashSet<TreeGraphNode>();
        Set<Tree> nodes = this.root.subTrees();
        for (TreeGraphNode treeGraphNode : nodes) {
            TreeGraphNode gov = this.getNodeInRelation(treeGraphNode, GrammaticalRelation.GOVERNOR);
            if (gov == null || gov != t) continue;
            deps.add(treeGraphNode);
        }
        return deps;
    }

    public TreeGraphNode getGovernor(TreeGraphNode t) {
        return t.followArcToNode(GrammaticalRelation.GOVERNOR);
    }

    public TreeGraphNode getNodeInRelation(TreeGraphNode t, GrammaticalRelation r) {
        return t.followArcToNode(r);
    }

    public GrammaticalRelation getGrammaticalRelation(int govIndex, int depIndex) {
        TreeGraphNode gov = this.getNodeByIndex(govIndex);
        TreeGraphNode dep = this.getNodeByIndex(depIndex);
        return this.getGrammaticalRelation(gov, dep);
    }

    public GrammaticalRelation getGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        GrammaticalRelation reln = GrammaticalRelation.DEPENDENT;
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        Set arcLabels = govH.arcLabelsToNode(depH);
        for (Object arcLabel : arcLabels) {
            GrammaticalRelation reln2;
            if (arcLabel == null || !(arcLabel instanceof GrammaticalRelation) || !reln.isAncestor(reln2 = (GrammaticalRelation)arcLabel)) continue;
            reln = reln2;
        }
        return reln;
    }

    public List<GrammaticalRelation> getListGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        ArrayList<GrammaticalRelation> list = new ArrayList<GrammaticalRelation>();
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        Set arcLabels = govH.arcLabelsToNode(depH);
        if (dep != depH) {
            Set arcLabels2 = govH.arcLabelsToNode(dep);
            arcLabels.addAll(arcLabels2);
        }
        for (Object arcLabel : arcLabels) {
            if (arcLabel == null || !(arcLabel instanceof GrammaticalRelation)) continue;
            GrammaticalRelation reln2 = (GrammaticalRelation)arcLabel;
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    GrammaticalRelation gr = (GrammaticalRelation)list.get(i);
                    if (gr.isAncestor(reln2)) {
                        int index = list.indexOf(gr);
                        list.set(index, reln2);
                        continue;
                    }
                    if (reln2.isAncestor(gr)) continue;
                    list.add(reln2);
                }
                continue;
            }
            list.add(reln2);
        }
        return list;
    }

    public Collection<TypedDependency> typedDependencies() {
        return this.typedDependencies(false);
    }

    public Collection<TypedDependency> allTypedDependencies() {
        return this.typedDependencies(true);
    }

    public Collection<TypedDependency> typedDependencies(boolean includeExtras) {
        if (includeExtras) {
            this.correctDependencies(this.allTypedDependencies);
            return this.allTypedDependencies;
        }
        this.correctDependencies(this.typedDependencies);
        return this.typedDependencies;
    }

    public Collection<TypedDependency> typedDependenciesCollapsed() {
        return this.typedDependenciesCollapsed(false);
    }

    public Collection<TypedDependency> typedDependenciesCollapsed(boolean includeExtras) {
        Collection<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, false);
        return tdl;
    }

    public Collection<TypedDependency> typedDependenciesCCprocessed(boolean includeExtras) {
        Collection<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, true);
        return tdl;
    }

    protected void collapseDependencies(Collection<TypedDependency> list, boolean CCprocess) {
    }

    protected void correctDependencies(Collection<TypedDependency> list) {
    }

    public List getDependencyPath(int nodeIndex, int rootIndex) {
        TreeGraphNode node = this.getNodeByIndex(nodeIndex);
        TreeGraphNode root = this.getNodeByIndex(rootIndex);
        return this.getDependencyPath(node, root);
    }

    public List getDependencyPath(TreeGraphNode node, TreeGraphNode root) {
        ArrayList<String> path = new ArrayList<String>();
        while (true) {
            TreeGraphNode gov = node.followArcToNode(GrammaticalRelation.GOVERNOR);
            Set relations = node.arcLabelsToNode(gov);
            StringBuffer sb = new StringBuffer();
            for (Object arcLabel : relations) {
                sb.append((sb.toString().length() == 0 ? "" : "+") + arcLabel.toString());
            }
            path.add(sb.toString());
            if (gov.equals(root)) break;
            node = gov;
        }
        return path;
    }

    public Map getAllDependents(TreeGraphNode node) {
        HashMap newMap = new HashMap();
        Map m = node.label.map();
        for (Object o : m.keySet()) {
            if (!(o instanceof GrammaticalRelation)) continue;
            newMap.put(o, m.get(o));
        }
        return newMap;
    }

    private static class NoPunctFilter
    implements Filter {
        private Filter npf;

        NoPunctFilter(Filter f) {
            this.npf = f;
        }

        public boolean accept(Object o) {
            if (o == null || !(o instanceof Dependency)) {
                return false;
            }
            Label s = ((Dependency)o).dependent();
            if (s == null || !(s instanceof TreeGraphNode)) {
                return false;
            }
            Label l = ((TreeGraphNode)s).label();
            if (l == null || !(l instanceof Label)) {
                return false;
            }
            return this.npf.accept(l.value());
        }
    }
}

