/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.SimpleTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.FilePathProcessor;
import edu.stanford.nlp.util.FileProcessor;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryTreebank
extends Treebank
implements FileProcessor,
List<Tree> {
    private static final boolean PRINT_FILENAMES = false;
    private ArrayList<Tree> parseTrees;

    public MemoryTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public MemoryTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public MemoryTreebank(TreeReaderFactory trf) {
        super(trf);
        this.parseTrees = new ArrayList();
    }

    public MemoryTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
        this.parseTrees = new ArrayList();
    }

    public MemoryTreebank(int initialCapacity) {
        this(initialCapacity, new SimpleTreeReaderFactory());
    }

    public MemoryTreebank(int initialCapacity, TreeReaderFactory trf) {
        super(initialCapacity, trf);
        this.parseTrees = new ArrayList(initialCapacity);
    }

    @Override
    public void clear() {
        this.parseTrees.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        FilePathProcessor.processPath(path, filt, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File file) {
        TreeReader tr = null;
        try {
            Tree pt;
            tr = this.treeReaderFactory().newTreeReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding())));
            int sentIndex = 0;
            while ((pt = tr.readTree()) != null) {
                if (pt.label() instanceof HasIndex) {
                    HasIndex hi = (HasIndex)((Object)pt.label());
                    hi.setDocID(file.getName());
                    hi.setSentIndex(sentIndex);
                }
                this.parseTrees.add(pt);
                ++sentIndex;
            }
        }
        catch (IOException e) {
            System.err.println("loadTree IO Exception: " + e + " in file " + file);
        }
        finally {
            try {
                if (tr != null) {
                    tr.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void load(Reader r) {
        this.load(r, null);
    }

    public void load(Reader r, String id) {
        TreeReader tr = null;
        try {
            Tree pt;
            tr = this.treeReaderFactory().newTreeReader(r);
            int sentIndex = 0;
            while ((pt = tr.readTree()) != null) {
                if (pt.label() instanceof HasIndex) {
                    HasIndex hi = (HasIndex)((Object)pt.label());
                    if (id != null) {
                        hi.setDocID(id);
                    }
                    hi.setSentIndex(sentIndex);
                }
                this.parseTrees.add(pt);
                ++sentIndex;
            }
        }
        catch (IOException e) {
            System.err.println("load IO Exception: " + e);
        }
    }

    @Override
    public Tree get(int i) {
        return this.parseTrees.get(i);
    }

    @Override
    public void apply(TreeVisitor tp) {
        int size = this.parseTrees.size();
        for (int i = 0; i < size; ++i) {
            tp.visitTree(this.parseTrees.get(i));
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        return this.parseTrees.iterator();
    }

    @Override
    public int size() {
        return this.parseTrees.size();
    }

    @Override
    public void add(int index, Tree element) {
        this.parseTrees.add(index, element);
    }

    @Override
    public boolean add(Tree element) {
        return this.parseTrees.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Tree> c) {
        return this.parseTrees.addAll(index, c);
    }

    @Override
    public int indexOf(Object o) {
        return this.parseTrees.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.parseTrees.lastIndexOf(o);
    }

    @Override
    public Tree remove(int index) {
        return this.parseTrees.remove(index);
    }

    @Override
    public Tree set(int index, Tree element) {
        return this.parseTrees.set(index, element);
    }

    @Override
    public ListIterator<Tree> listIterator() {
        return this.parseTrees.listIterator();
    }

    @Override
    public ListIterator<Tree> listIterator(int index) {
        return this.parseTrees.listIterator(index);
    }

    @Override
    public List<Tree> subList(int fromIndex, int toIndex) {
        return this.parseTrees.subList(fromIndex, toIndex);
    }

    @Override
    public Treebank transform(TreeTransformer treeTrans) {
        MemoryTreebank mtb = new MemoryTreebank(this.size(), this.treeReaderFactory());
        for (Tree t : this) {
            ((AbstractCollection)mtb).add(treeTrans.transformTree(t));
        }
        return mtb;
    }

    public static void main(String[] args) {
        Timing.startTime();
        MemoryTreebank treebank = new MemoryTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        treebank.loadPath(args[0]);
        Timing.endTime();
        System.out.println(treebank);
    }
}

