/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class ViewerUpdateMonitor
extends Request
implements IViewerUpdate {
    private ModelContentProvider fContentProvider;
    private TreePath fElementPath;
    private Object fElement;
    private IElementContentProvider fElementContentProvider;
    private boolean fDone = false;
    private boolean fStarted = false;
    private Object fViewerInput = null;
    private boolean fIsDelegated = false;
    private IPresentationContext fContext;
    protected WorkbenchJob fViewerUpdateJob = new WorkbenchJob("Asynchronous viewer update"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                IStatus status;
                if (!(ViewerUpdateMonitor.this.isCanceled() || ViewerUpdateMonitor.this.getContentProvider().isDisposed() || (status = ViewerUpdateMonitor.this.getStatus()) != null && !status.isOK())) {
                    ViewerUpdateMonitor.this.performUpdate();
                }
            }
            finally {
                ViewerUpdateMonitor.this.getContentProvider().updateComplete(ViewerUpdateMonitor.this);
            }
            return Status.OK_STATUS;
        }
    };

    public ViewerUpdateMonitor(ModelContentProvider contentProvider, Object viewerInput, TreePath elementPath, Object element, IElementContentProvider elementContentProvider, IPresentationContext context) {
        this.fContext = context;
        this.fViewerInput = viewerInput;
        this.fElementContentProvider = elementContentProvider;
        this.fContentProvider = contentProvider;
        this.fElement = element;
        this.fElementPath = elementPath;
        this.fViewerUpdateJob.setRule(this.getUpdateSchedulingRule());
        this.fViewerUpdateJob.setSystem(true);
    }

    protected ISchedulingRule getUpdateSchedulingRule() {
        return AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(this.getContentProvider());
    }

    protected ModelContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    protected IElementContentProvider getElementContentProvider() {
        return this.fElementContentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void done() {
        ViewerUpdateMonitor viewerUpdateMonitor = this;
        synchronized (viewerUpdateMonitor) {
            if (this.isDone()) {
                return;
            }
            this.fDone = true;
        }
        this.scheduleViewerUpdate();
    }

    protected synchronized boolean isDone() {
        return this.fDone;
    }

    protected void scheduleViewerUpdate() {
        if (!this.isCanceled()) {
            this.fViewerUpdateJob.schedule();
        } else {
            this.getContentProvider().updateComplete(this);
        }
    }

    protected abstract void performUpdate();

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    public Object getElement() {
        return this.fElement;
    }

    public TreePath getElementPath() {
        return this.fElementPath;
    }

    abstract boolean coalesce(ViewerUpdateMonitor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() {
        ViewerUpdateMonitor viewerUpdateMonitor = this;
        synchronized (viewerUpdateMonitor) {
            if (this.fStarted) {
                return;
            }
            this.fStarted = true;
        }
        this.getContentProvider().updateStarted(this);
        if (!this.isCanceled()) {
            this.startRequest();
        } else {
            this.done();
        }
    }

    public Object getViewerInput() {
        return this.fViewerInput;
    }

    abstract void startRequest();

    abstract int getPriority();

    abstract TreePath getSchedulingPath();

    public void setDelegated(boolean delegated) {
        this.fIsDelegated = delegated;
    }

    public boolean isDelegated() {
        return this.fIsDelegated;
    }
}

