/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.views;

import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.Pointer;
import edu.mit.story.core.util.Debug;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.WordnetUIUtils;
import edu.mit.wordnet.ui.content.SynsetContentProvider;
import edu.mit.wordnet.ui.label.SynsetLabelProvider;
import edu.mit.wordnet.ui.views.SynsetHierarchyPage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ResourceAction;

public class SynsetHierarchyViewPart
extends ViewPart {
    public static final int PROPERTY_CURRENTPAGE = 1;
    PageBook fPagebook;
    SynsetHierarchyPage defaultPage;
    SynsetHierarchyPage currentPage;
    Map<ISynset, SynsetHierarchyPage> pages = new LinkedHashMap<ISynset, SynsetHierarchyPage>();
    Map<SynsetHierarchyPage, SelectPreviousHierarchyAction> prevActions = new HashMap<SynsetHierarchyPage, SelectPreviousHierarchyAction>();
    ChoosePointerTypeAction fChoosePointerTypeAction;
    ShowSynsetHistoryDialogAction fShowHistoryDialogAction;
    ShowSynsetIDsAction fShowSynsetIDAction;
    SynsetLabelProvider fLabelProvider;
    SynsetContentProvider fContentProvider;

    public void createPartControl(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.createActions();
        this.defaultPage = this.createPage(null);
        this.setInput(null);
    }

    protected void createActions() {
        this.fShowHistoryDialogAction = new ShowSynsetHistoryDialogAction(this.pages.size() > 0, new SynsetHistoryMenuCreator());
        this.fChoosePointerTypeAction = new ChoosePointerTypeAction();
        this.fShowSynsetIDAction = new ShowSynsetIDsAction(this.getLabelProvider().showsIDs());
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.fChoosePointerTypeAction);
        toolbar.add((IAction)this.fShowHistoryDialogAction);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add((IAction)this.fShowSynsetIDAction);
    }

    public PageBook getPageBook() {
        return this.fPagebook;
    }

    public void setFocus() {
        if (this.fPagebook != null) {
            this.fPagebook.setFocus();
        }
    }

    public void setInput(ISynset selection) {
        SynsetHierarchyPage page = null;
        page = selection == null ? this.defaultPage : this.pages.get(selection);
        if (page == null) {
            page = this.createPage(selection);
        }
        this.showPage(page);
    }

    public ISynset getInput() {
        if (this.currentPage == null) {
            return null;
        }
        return this.currentPage.getInput();
    }

    public SynsetLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new SynsetLabelProvider(true);
        }
        return this.fLabelProvider;
    }

    public SynsetContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public void showPage(SynsetHierarchyPage page) {
        if (!this.setCurrentPage(page)) {
            return;
        }
        page.refresh();
        this.getSite().setSelectionProvider((ISelectionProvider)this.currentPage.getTreeViewer());
        this.fPagebook.showPage((Control)page);
    }

    protected boolean setCurrentPage(SynsetHierarchyPage page) {
        if (page == null) {
            return false;
        }
        if (page == this.currentPage) {
            return false;
        }
        this.currentPage = page;
        this.firePropertyChange(1);
        return true;
    }

    protected SynsetHierarchyPage createPage(ISynset synset) {
        if (this.getPageBook() == null) {
            return null;
        }
        SynsetHierarchyPage page = new SynsetHierarchyPage(synset, this, 0);
        if (synset != null) {
            this.pages.put(synset, page);
            this.fShowHistoryDialogAction.setEnabled(true);
            this.fShowHistoryDialogAction.getHistoryMenuCreator().setOutOfSync();
        }
        return page;
    }

    protected void removePage(ISynset synset) {
        SynsetHierarchyPage page = this.pages.remove(synset);
        if (page != null) {
            page.dispose();
        }
        this.prevActions.remove((Object)page);
        this.fShowHistoryDialogAction.setEnabled(this.pages.size() > 0);
        this.fShowHistoryDialogAction.getHistoryMenuCreator().setOutOfSync();
    }

    protected class ChoosePointerTypeAction
    extends ResourceAction
    implements IMenuCreator {
        Menu fMenu;

        public ChoosePointerTypeAction() {
            super(WordnetUIMessages.getBundle(), WordnetUIMessages.ACTION_ChoosePointerType_prefix);
            this.setMenuCreator(this);
        }

        public void run() {
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                return this.fMenu;
            }
            this.fMenu = new Menu(parent);
            Iterator iterator = Pointer.values().iterator();
            while (iterator.hasNext()) {
                IPointer type;
                ActionContributionItem item = new ActionContributionItem((IAction)new SelectPointerType(type, (type = (IPointer)iterator.next()) == SynsetHierarchyViewPart.this.getContentProvider().getPointerType()));
                item.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    protected class SelectPointerType
    extends ResourceAction
    implements IPropertyListener {
        IPointer fType;

        public SelectPointerType(IPointer type, boolean initiallyChecked) {
            super(WordnetUIMessages.getBundle(), WordnetUIMessages.ACTION_SelectPointerType_prefix);
            if (type == null) {
                throw new NullPointerException();
            }
            this.fType = type;
            this.setText(type.getName());
            this.setChecked(initiallyChecked);
            SynsetHierarchyViewPart.this.getContentProvider().addPropertyListener(this);
        }

        public void run() {
            SynsetHierarchyViewPart.this.getContentProvider().setPointerType(this.fType);
            SynsetHierarchyViewPart.this.currentPage.refresh();
        }

        public void propertyChanged(Object source, int propId) {
            if (source != SynsetHierarchyViewPart.this.getContentProvider() | propId != 1) {
                return;
            }
            super.setChecked(this.fType == SynsetHierarchyViewPart.this.getContentProvider().getPointerType());
        }

        public void setChecked() {
        }
    }

    protected class SelectPreviousHierarchyAction
    extends Action
    implements IPropertyListener {
        SynsetHierarchyPage fPage;

        public SelectPreviousHierarchyAction(SynsetHierarchyPage page, boolean initiallyChecked) {
            if (page == null) {
                throw new NullPointerException();
            }
            this.fPage = page;
            String key = WordnetUIUtils.getIconPNGImageKey(this.fPage.getInput().getPOS());
            this.setImageDescriptor(WordnetUIPlugin.getDefault().getImageRegistry().getDescriptor(key));
            SynsetHierarchyViewPart.this.addPropertyListener(this);
            super.setChecked(initiallyChecked);
            this.refresh();
        }

        public void refresh() {
            this.setText(SynsetHierarchyViewPart.this.getLabelProvider().getText(this.fPage.getInput()));
        }

        public void run() {
            SynsetHierarchyViewPart.this.showPage(this.fPage);
        }

        public void propertyChanged(Object source, int propId) {
            if (source != SynsetHierarchyViewPart.this | propId != 1) {
                return;
            }
            super.setChecked(this.fPage == SynsetHierarchyViewPart.this.currentPage);
        }

        public void setChecked() {
        }
    }

    protected class ShowSynsetHistoryDialogAction
    extends ResourceAction2 {
        SynsetHistoryMenuCreator fMenuCreator;

        public ShowSynsetHistoryDialogAction(boolean enabled, SynsetHistoryMenuCreator menuCreator) {
            super(WordnetUIMessages.getBundle(), WordnetUIMessages.ACTION_PreviousSynsetHierarchies_prefix);
            this.setEnabled(enabled);
            this.fMenuCreator = menuCreator;
            this.setMenuCreator(this.fMenuCreator);
        }

        public SynsetHistoryMenuCreator getHistoryMenuCreator() {
            return this.fMenuCreator;
        }

        public void run() {
            Debug.implement();
        }
    }

    protected class ShowSynsetIDsAction
    extends ResourceAction {
        public ShowSynsetIDsAction(boolean initiallyChecked) {
            super(WordnetUIMessages.getBundle(), WordnetUIMessages.ACTION_ShowSynsetIDs_prefix, 2);
            this.setChecked(initiallyChecked);
        }

        public void run() {
            SynsetHierarchyViewPart.this.fLabelProvider.setShowIDs(this.isChecked());
            SynsetHierarchyViewPart.this.currentPage.refresh();
            SynsetHierarchyViewPart.this.fShowHistoryDialogAction.getHistoryMenuCreator().setOutOfSync();
        }
    }

    protected class SynsetHistoryMenuCreator
    implements IMenuCreator {
        boolean fInSync = false;
        Menu fMenu = null;
        IAction fMyShowHistoryDialogAction;

        protected SynsetHistoryMenuCreator() {
            this.fMyShowHistoryDialogAction = new ShowSynsetHistoryDialogAction(true, null);
        }

        public void setOutOfSync() {
            this.fInSync = false;
        }

        public Menu getMenu(Control parent) {
            ActionContributionItem item;
            if (this.fInSync & this.fMenu != null) {
                return this.fMenu;
            }
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            for (Map.Entry<ISynset, SynsetHierarchyPage> entry : SynsetHierarchyViewPart.this.pages.entrySet()) {
                if (entry.getKey() == null) continue;
                SelectPreviousHierarchyAction action = SynsetHierarchyViewPart.this.prevActions.get((Object)entry.getValue());
                if (action == null) {
                    action = new SelectPreviousHierarchyAction(entry.getValue(), entry.getValue() == SynsetHierarchyViewPart.this.currentPage);
                    SynsetHierarchyViewPart.this.prevActions.put(entry.getValue(), action);
                } else {
                    action.refresh();
                }
                item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
            }
            new MenuItem(this.fMenu, 2);
            item = new ActionContributionItem(this.fMyShowHistoryDialogAction);
            item.fill(this.fMenu, -1);
            this.fInSync = true;
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }
    }
}

