/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.data.parse.MisformattedLineException;
import edu.mit.jwi.data.parse.SenseKeyParser;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.SenseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenseLineParser
implements ILineParser<ISenseEntry> {
    private static char space = (char)32;
    private static SenseLineParser fInstance;
    private ILineParser<ISenseKey> keyParser;

    public static SenseLineParser getInstance() {
        if (fInstance == null) {
            fInstance = new SenseLineParser();
        }
        return fInstance;
    }

    protected SenseLineParser() {
    }

    protected ILineParser<ISenseKey> getSenseKeyParser() {
        if (this.keyParser == null) {
            this.keyParser = SenseKeyParser.getInstance();
        }
        return this.keyParser;
    }

    @Override
    public ISenseEntry parseLine(String line) {
        if (line == null) {
            throw new MisformattedLineException(line);
        }
        try {
            int begin = 0;
            int end = 0;
            end = line.indexOf(space, begin);
            String keyStr = line.substring(begin, end);
            ISenseKey sense_key = this.getSenseKeyParser().parseLine(keyStr);
            begin = end + 1;
            end = line.indexOf(space, begin);
            int synset_offset = Integer.parseInt(line.substring(begin, end));
            begin = end + 1;
            end = line.indexOf(space, begin);
            int sense_number = Integer.parseInt(line.substring(begin, end));
            begin = end + 1;
            int tag_cnt = Integer.parseInt(line.substring(begin));
            return new SenseEntry(sense_key, synset_offset, sense_number, tag_cnt);
        }
        catch (Exception e) {
            throw new MisformattedLineException(line, e);
        }
    }
}

