/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.event.EventClassifer;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.IndexedEvent;
import edu.mit.semantics.core.rep.event.model.EventModel;
import edu.mit.semantics.core.rep.event.model.IEventModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.factory.AbstractDescFactory2;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IFlag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.DistinctRegionSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDescFactory
extends AbstractDescFactory2<IndexedEvent> {
    public EventDescFactory() {
        super(EventRep.getInstance(), new IRep[]{TokenRep.getInstance(), POSRep.getInstance(), SentenceRep.getInstance()});
    }

    protected DistinctRegionSet calculateRegions(StoryChangeEvent event) {
        IMutableStoryModel model = event.provider;
        if (!model.supports(POSRep.getInstance())) {
            return null;
        }
        Change change = event.getChange(TokenRep.getInstance());
        if (change == null) {
            return null;
        }
        IHasPositionSet regions = change.getChanges((IFlag)Flag.DESCS);
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        DistinctRegionSet result = new DistinctRegionSet();
        if (model.supports(SentenceRep.getInstance())) {
            IDescSet sentences = event.provider.getData().getDescriptions(SentenceRep.getInstance());
            for (IHasPosition region : regions) {
                result.addAll((Collection)sentences.openSet(region));
            }
        } else {
            result.add((IHasPosition)new SimplePosition((IHasPosition)regions));
        }
        return result;
    }

    protected IHasPositionSet<IndexedEvent> calculateData(IHasPosition region, IStoryModel model) {
        if (!model.supports(POSRep.getInstance())) {
            return null;
        }
        HasPositionSet results = new HasPositionSet();
        EventModel eventModel = new EventModel(model, false);
        for (IDesc desc : model.getData().getDescriptions(POSRep.getInstance()).closedSet(region)) {
            IndexedEvent idxEvent;
            IPosTag tag = (IPosTag)desc.getData();
            if (!tag.getTag().isVerb() || tag.isAuxiliary() || (idxEvent = this.toIndexedEvent(eventModel, desc, model)) == null) continue;
            results.add((Object)idxEvent);
        }
        return results;
    }

    protected IndexedEvent toIndexedEvent(IEventModel eventModel, IDesc posDesc, IStoryModel model) {
        IDesc last;
        IDescSet descs = model.getData().getDescriptions(TokenRep.getInstance());
        IDescSet tokensMatch = descs.matchSet((IHasPosition)posDesc);
        if (tokensMatch.isEmpty()) {
            return null;
        }
        IDesc tokenDesc = (IDesc)tokensMatch.first();
        DescSet tokens = new DescSet(TokenRep.getInstance());
        tokens.add((Object)tokenDesc);
        descs = descs.headSet(tokenDesc);
        while (EventClassifer.isFunctionWord(last = (IDesc)descs.last())) {
            tokens.add((Object)last);
            descs = descs.headSet(last);
        }
        eventModel.clear();
        eventModel.getEventModel().setSegments(Collections.singleton(new Segment((IHasPosition)tokens, TokenRep.getInstance(), model.getData())));
        EventClassifer.getInstance().classify(eventModel);
        IEvent event = null;
        try {
            event = eventModel.toEvent();
        }
        catch (Exception exception) {
            return null;
        }
        return new IndexedEvent(event);
    }
}

