/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole;

import com.eventmonitor.srl.iterators.IPredicateInfo;
import com.eventmonitor.srl.iterators.ISentenceInfo;
import com.eventmonitor.srl.labeler.IArgParsePair;
import com.eventmonitor.srl.labeler.SemanticRoleLabeler;
import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.INode;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.PredicateFeatures;
import edu.mit.jpropbank.PropbankEntryParser;
import edu.mit.jpropbank.Tense;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.semantics.core.propbank.GenericRoleSet;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.ISemRoleLabeler;
import edu.mit.semantics.core.rep.semrole.SemRole;
import edu.mit.semantics.core.rep.semrole.SemanticRoleLabelerSingleton;
import edu.mit.story.core.algorithm.AbstractAlgorithm;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.text.TextRep;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericLabeler
extends AbstractAlgorithm
implements ISemRoleLabeler {
    protected SemanticRoleLabeler labeler;

    protected boolean doInit() {
        this.labeler = SemanticRoleLabelerSingleton.getInstance();
        return true;
    }

    public void dispose() {
        this.labeler = null;
    }

    @Override
    public List<ISemRole> label(IDesc desc, IStoryModel model) {
        String text = TextRep.getText((IHasPosition)desc, (IStoryData)model.getData());
        ITree tree = (ITree)desc.getData();
        ISentenceInfo si = this.labeler.labelRoles((Parse)new ParseTree(text, desc.getOffset(), tree));
        ArrayList<ISemRole> result = new ArrayList<ISemRole>(si.getPredicates().size());
        for (IPredicateInfo pi : si.getPredicates()) {
            result.add(GenericLabeler.toSemRole(pi, desc));
        }
        return result;
    }

    public static ISemRole toSemRole(IPredicateInfo pi, IDesc desc) {
        ITree tree = (ITree)desc.getData();
        IPredicateFeatures pf = GenericLabeler.toPredFeatures((com.eventmonitor.srl.propbank.IPredicateFeatures)pi.getPredicateAnalysis());
        ArrayList<ISemArg> args = new ArrayList<ISemArg>(pi.getArguments().size());
        PropbankEntryParser propParser = PropbankEntryParser.getInstance();
        for (IArgParsePair arg : pi.getArguments()) {
            IArg origArg = propParser.parseArg(arg.getArgument().toString());
            args.add(SemRole.recalculate(null, (IArg<? extends INode>)origArg, tree));
        }
        return new SemRole((IRoleset)GenericRoleSet.getInstance(), desc, pi.getPredicateAnalysis().getTerminalNum(), pf, args, false);
    }

    public static IPredicateFeatures toPredFeatures(com.eventmonitor.srl.propbank.IPredicateFeatures p) {
        Form form = Form.get((char)p.getForm().getIdentifier());
        Tense tense = Tense.get((char)p.getTense().getIdentifier());
        Aspect aspect = Aspect.get((char)p.getAspect().getIdentifier());
        boolean isActive = p.getVoice().getIdentifier() == 'a';
        boolean isThirdPerson = p.getPerson().getIdentifier() == '3';
        return new PredicateFeatures(form, tense, aspect, isThirdPerson, isActive);
    }

    public static Span toSpan(int anchor, IHasPosition p) {
        return new Span(p.getOffset() - anchor, p.getRightOffset() - anchor);
    }

    public static class ParseTree
    extends Parse {
        private final ITree backing;

        public ParseTree(String text, int anchor, ITree backing) {
            super(text, GenericLabeler.toSpan(anchor, backing.calculatePosition()), backing.isLeaf() ? "TK" : backing.getLabel(), Double.NaN);
            for (ITree child : backing.getChildren()) {
                this.insert(new ParseTree(text, anchor, child));
            }
            if (backing == null) {
                throw new NullPointerException();
            }
            this.backing = backing;
        }

        public ITree getTree() {
            return this.backing;
        }
    }
}

