/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core;

import edu.mit.jmwe.index.IMWEIndex;
import edu.mit.jmwe.index.MWEIndex;
import edu.mit.parsing.core.rep.parse.IParser;
import edu.mit.parsing.core.rep.parse.ParserManager;
import edu.mit.parsing.core.rep.pos.IPOSTagger;
import edu.mit.parsing.core.rep.pos.POSTaggerManager;
import edu.mit.parsing.core.rep.sentence.ISentenceDetector;
import edu.mit.parsing.core.rep.sentence.SentenceDetectorManager;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.parsing.core.rep.stem.algorithm.StemmerManager;
import edu.mit.parsing.core.rep.tag.tagset.TagsetListener;
import edu.mit.parsing.core.rep.tag.tagset.manager.ITagsetManager;
import edu.mit.parsing.core.rep.tag.tagset.manager.TagsetManager;
import edu.mit.parsing.core.rep.token.ITokenizer;
import edu.mit.parsing.core.rep.token.TokenizerManager;
import edu.mit.story.core.IdentifiedPlugin;
import edu.mit.story.core.algorithm.IAlgorithmManager;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingPlugin
extends IdentifiedPlugin
implements IStartup {
    public static final String ID = "edu.mit.parsing.core";
    private static ParsingPlugin plugin = null;
    IAlgorithmManager<ITokenizer> tokenizerManager;
    IAlgorithmManager<IStemmer> stemmerManager;
    IAlgorithmManager<ISentenceDetector> detectorManager;
    IAlgorithmManager<IPOSTagger> taggerManager;
    IAlgorithmManager<IParser> parserManager;
    IMWEIndex mweIndex;
    TagsetListener tagsetListener;
    ITagsetManager tagsetManager;

    public static ParsingPlugin getDefault() {
        return plugin;
    }

    public ParsingPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
                ParsingPlugin.this.tagsetListener.doneSaving(context);
                ParsingPlugin.this.tagsetManager.doneSaving(context);
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
                try {
                    ParsingPlugin.this.tagsetListener.prepareToSave(context);
                }
                catch (CoreException e) {
                    ParsingPlugin.this.getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ParsingPlugin.ID, "", (Throwable)e));
                }
                try {
                    ParsingPlugin.this.tagsetManager.prepareToSave(context);
                }
                catch (CoreException e) {
                    ParsingPlugin.this.getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ParsingPlugin.ID, "", (Throwable)e));
                }
            }

            public void rollback(ISaveContext context) {
                ParsingPlugin.this.tagsetListener.rollback(context);
                ParsingPlugin.this.tagsetManager.rollback(context);
            }

            public void saving(ISaveContext context) throws CoreException {
                try {
                    ParsingPlugin.this.tagsetListener.saving(context);
                }
                catch (CoreException e) {
                    ParsingPlugin.this.getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ParsingPlugin.ID, "", (Throwable)e));
                }
                try {
                    ParsingPlugin.this.tagsetManager.saving(context);
                }
                catch (CoreException e) {
                    ParsingPlugin.this.getLog().log((IStatus)new Status(e.getStatus().getSeverity(), ParsingPlugin.ID, "", (Throwable)e));
                }
            }
        });
        TagsetListener tagsetListener = new TagsetListener();
        tagsetListener.load(lastState);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)tagsetListener);
        this.tagsetListener = tagsetListener;
        TagsetManager tagsetManager = new TagsetManager();
        tagsetManager.init();
        tagsetManager.load(lastState);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)tagsetManager);
        this.tagsetManager = tagsetManager;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public ITagsetManager getTagsetManager() {
        return this.tagsetManager;
    }

    public IAlgorithmManager<ITokenizer> getTokenizerManager() {
        if (this.tokenizerManager == null) {
            this.tokenizerManager = new TokenizerManager();
            this.tokenizerManager.init();
        }
        return this.tokenizerManager;
    }

    public IAlgorithmManager<IStemmer> getStemmerManager() {
        if (this.stemmerManager == null) {
            this.stemmerManager = new StemmerManager();
            this.stemmerManager.init();
        }
        return this.stemmerManager;
    }

    public IAlgorithmManager<ISentenceDetector> getSentenceDetectorManager() {
        if (this.detectorManager == null) {
            this.detectorManager = new SentenceDetectorManager();
            this.detectorManager.init();
        }
        return this.detectorManager;
    }

    public IAlgorithmManager<IPOSTagger> getTaggerManager() {
        if (this.taggerManager == null) {
            this.taggerManager = new POSTaggerManager();
            this.taggerManager.init();
        }
        return this.taggerManager;
    }

    public IAlgorithmManager<IParser> getParserManager() {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager();
            this.parserManager.init();
        }
        return this.parserManager;
    }

    public IMWEIndex getMWEIndex() {
        if (this.mweIndex == null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("lib/mweindex_wordnet3.0_semcor1.6.data"), null);
            this.mweIndex = new MWEIndex(url);
            try {
                this.mweIndex.open();
            }
            catch (IOException e) {
                Status status = new Status(4, this.getID(), "There was a problem openings the mwe index data file.", (Throwable)e);
                this.getLog().log((IStatus)status);
                return null;
            }
        }
        return this.mweIndex;
    }

    public void earlyStartup() {
    }
}

