/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.parse;

import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.Tree;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreeTranslator {
    private static TreeTranslator instance = null;
    protected static final Pattern whitespace = Pattern.compile("\\s+");
    protected static final Pattern tokenID = Pattern.compile("(\\S+)_(\\d+)$");

    public static TreeTranslator getInstance() {
        if (instance == null) {
            instance = new TreeTranslator();
        }
        return instance;
    }

    protected TreeTranslator() {
    }

    public ITree fromString(CharSequence seq, IDescSet tokens) {
        LinkedList<StringBuilder> labels = new LinkedList<StringBuilder>();
        LinkedList siblings = new LinkedList();
        State state = State.BODY;
        int i = 0;
        while (i < seq.length()) {
            char c = seq.charAt(i);
            switch (state) {
                case OPEN: {
                    labels.addFirst(new StringBuilder());
                    siblings.addFirst(new LinkedList());
                    break;
                }
                case CLOSE: {
                    String label = ((StringBuilder)labels.removeFirst()).toString().trim();
                    List children = (List)siblings.removeFirst();
                    Tree node = null;
                    node = children.isEmpty() ? this.toLeafBranch(label, tokens) : new Tree(label.toString(), children);
                    ((List)siblings.peek()).add(node);
                }
            }
            if (c == '(') {
                state = State.OPEN;
            } else if (c == ')') {
                state = State.CLOSE;
            } else {
                ((StringBuilder)labels.peek()).append(c);
                state = State.BODY;
            }
            ++i;
        }
        Tree result = new Tree(((StringBuilder)labels.removeFirst()).toString().trim(), (List)siblings.removeFirst());
        result.setParent(null);
        return result;
    }

    protected Tree toLeafBranch(CharSequence label, IDescSet tokens) {
        String[] parts = whitespace.split(label);
        switch (parts.length) {
            case 0: {
                return new Tree();
            }
            case 1: {
                return this.toLeaf(parts[0], tokens);
            }
            case 2: {
                return new Tree(parts[0], Collections.singletonList(this.toLeaf(parts[1], tokens)), false);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Tree toLeaf(CharSequence label, IDescSet tokens) {
        Matcher matcher = tokenID.matcher(label);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        IDesc desc = tokens.getDescription(Long.parseLong(matcher.group(2)));
        return new Tree(matcher.group(1), desc);
    }

    public String toString(ITree tree) {
        StringBuilder sb = new StringBuilder();
        if (tree.isLeaf()) {
            IDesc iDesc = (IDesc)tree.getTokens().first();
            sb.append(tree.getLabel());
            sb.append('_');
            sb.append(Long.toString(iDesc.getID()));
        } else {
            sb.append('(');
            sb.append(tree.getLabel());
            for (ITree iTree : tree.getChildren()) {
                sb.append(' ');
                sb.append(this.toString(iTree));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OPEN,
        BODY,
        CLOSE;

    }
}

