/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos.problems;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedTokenProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.untaggedToken";

    public UntaggedTokenProblem(IDesc token, String buildRuleID) {
        this(Collections.singleton(token), buildRuleID);
    }

    public UntaggedTokenProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(POSRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Untagged Token");
        this.setDescs(descs);
        IDescSet tokens = this.getDescs().getDescriptions(TokenRep.getInstance());
        IDescSet collocs = this.getDescs().getDescriptions(CollocRep.getInstance());
        HasPositionSet ds = new HasPositionSet();
        ds.addAll((Collection)tokens);
        ds.addAll((Collection)collocs);
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (ds.size() > 1) {
            this.setDescription("There are " + ds.size() + " tokens with no parts of speech assigned (only first shown)");
            this.setPosition((IHasPosition)ds.first());
        } else {
            IDesc d = (IDesc)ds.first();
            IBaseToken tok = (IBaseToken)d.getData();
            this.setPosition((IHasPosition)d);
            this.setDescription("The token '" + tok.getSurface() + "' has no part of speech");
        }
    }
}

